<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_HotelInventoryContactNumberType EnumType
 * @subpackage Enumerations
 */
class JPSOAP_HotelInventoryContactNumberType
{
    /**
     * Constant for value 'GEN'
     * @return string 'GEN'
     */
    const VALUE_GEN = 'GEN';
    /**
     * Constant for value 'BOOK'
     * @return string 'BOOK'
     */
    const VALUE_BOOK = 'BOOK';
    /**
     * Constant for value 'ADM'
     * @return string 'ADM'
     */
    const VALUE_ADM = 'ADM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GEN
     * @uses self::VALUE_BOOK
     * @uses self::VALUE_ADM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GEN,
            self::VALUE_BOOK,
            self::VALUE_ADM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
