<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightItem StructType
 * @subpackage Structs
 */
class JP_FlightItem extends JP_BaseItem
{
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Routes
     */
    public $Routes;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AdditionalElements
     */
    public $AdditionalElements;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Ticketing
     * @var bool
     */
    public $Ticketing;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * Constructor method for JP_FlightItem
     * @uses JP_FlightItem::setRoutes()
     * @uses JP_FlightItem::setAdditionalElements()
     * @uses JP_FlightItem::setRelPaxes()
     * @uses JP_FlightItem::setTicketing()
     * @uses JP_FlightItem::setDirection()
     * @param \StructType\JP_Routes $routes
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param bool $ticketing
     * @param string $direction
     */
    public function __construct(\StructType\JP_Routes $routes = null, \StructType\JP_AdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $ticketing = null, $direction = null)
    {
        $this
            ->setRoutes($routes)
            ->setAdditionalElements($additionalElements)
            ->setRelPaxes($relPaxes)
            ->setTicketing($ticketing)
            ->setDirection($direction);
    }
    /**
     * Get Routes value
     * @return \StructType\JP_Routes|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \StructType\JP_Routes $routes
     * @return \StructType\JP_FlightItem
     */
    public function setRoutes(\StructType\JP_Routes $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_AdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @return \StructType\JP_FlightItem
     */
    public function setAdditionalElements(\StructType\JP_AdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_FlightItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return bool|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @param bool $ticketing
     * @return \StructType\JP_FlightItem
     */
    public function setTicketing($ticketing = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketing) && !is_bool($ticketing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ticketing)), __LINE__);
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_FlightItem
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
