<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseStation StructType
 * @subpackage Structs
 */
class JP_CruiseStation extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Days
     * @var int
     */
    public $Days;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CruiseStation
     * @uses JP_CruiseStation::setType()
     * @uses JP_CruiseStation::setPrices()
     * @uses JP_CruiseStation::setCode()
     * @uses JP_CruiseStation::setDays()
     * @uses JP_CruiseStation::setRatePlanCode()
     * @param string $type
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $code
     * @param int $days
     * @param string $ratePlanCode
     */
    public function __construct($type = null, \ArrayType\ArrayOfJP_Price $prices = null, $code = null, $days = null, $ratePlanCode = null)
    {
        $this
            ->setType($type)
            ->setPrices($prices)
            ->setCode($code)
            ->setDays($days)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\StationsType::valueIsValid()
     * @uses \EnumType\StationsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_CruiseStation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StationsType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\StationsType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_CruiseStation
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CruiseStation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Days value
     * @return int|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\JP_CruiseStation
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !is_numeric($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseStation
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseStation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
