<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Price ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Price extends AbstractStructArrayBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Price[]
     */
    public $Price;
    /**
     * Constructor method for ArrayOfJP_Price
     * @uses ArrayOfJP_Price::setPrice()
     * @param \StructType\JP_Price[] $price
     */
    public function __construct(array $price = array())
    {
        $this
            ->setPrice($price);
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Price[] $price
     * @return \ArrayType\ArrayOfJP_Price
     */
    public function setPrice(array $price = array())
    {
        foreach ($price as $arrayOfJP_PricePriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PricePriceItem instanceof \StructType\JP_Price) {
                throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \StructType\JP_Price, "%s" given', is_object($arrayOfJP_PricePriceItem) ? get_class($arrayOfJP_PricePriceItem) : gettype($arrayOfJP_PricePriceItem)), __LINE__);
            }
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Price $item
     * @return \ArrayType\ArrayOfJP_Price
     */
    public function addToPrice(\StructType\JP_Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Price) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \StructType\JP_Price, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Price|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Price|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Price|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Price|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Price|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Price
     */
    public function getAttributeName()
    {
        return 'Price';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Price
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
