<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PackageSearcherItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PackageSearcherItem extends AbstractStructArrayBase
{
    /**
     * The PackageSearcherItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageSearcherItem[]
     */
    public $PackageSearcherItem;
    /**
     * Constructor method for ArrayOfJP_PackageSearcherItem
     * @uses ArrayOfJP_PackageSearcherItem::setPackageSearcherItem()
     * @param \StructType\JP_PackageSearcherItem[] $packageSearcherItem
     */
    public function __construct(array $packageSearcherItem = array())
    {
        $this
            ->setPackageSearcherItem($packageSearcherItem);
    }
    /**
     * Get PackageSearcherItem value
     * @return \StructType\JP_PackageSearcherItem[]|null
     */
    public function getPackageSearcherItem()
    {
        return $this->PackageSearcherItem;
    }
    /**
     * Set PackageSearcherItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageSearcherItem[] $packageSearcherItem
     * @return \ArrayType\ArrayOfJP_PackageSearcherItem
     */
    public function setPackageSearcherItem(array $packageSearcherItem = array())
    {
        foreach ($packageSearcherItem as $arrayOfJP_PackageSearcherItemPackageSearcherItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PackageSearcherItemPackageSearcherItemItem instanceof \StructType\JP_PackageSearcherItem) {
                throw new \InvalidArgumentException(sprintf('The PackageSearcherItem property can only contain items of \StructType\JP_PackageSearcherItem, "%s" given', is_object($arrayOfJP_PackageSearcherItemPackageSearcherItemItem) ? get_class($arrayOfJP_PackageSearcherItemPackageSearcherItemItem) : gettype($arrayOfJP_PackageSearcherItemPackageSearcherItemItem)), __LINE__);
            }
        }
        $this->PackageSearcherItem = $packageSearcherItem;
        return $this;
    }
    /**
     * Add item to PackageSearcherItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageSearcherItem $item
     * @return \ArrayType\ArrayOfJP_PackageSearcherItem
     */
    public function addToPackageSearcherItem(\StructType\JP_PackageSearcherItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageSearcherItem) {
            throw new \InvalidArgumentException(sprintf('The PackageSearcherItem property can only contain items of \StructType\JP_PackageSearcherItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PackageSearcherItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PackageSearcherItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PackageSearcherItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PackageSearcherItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PackageSearcherItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PackageSearcherItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PackageSearcherItem
     */
    public function getAttributeName()
    {
        return 'PackageSearcherItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PackageSearcherItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
