<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Meeting ServiceType
 * @subpackage Services
 */
class Meeting extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MeetingPointList
     * Meta informations extracted from the WSDL
     * - documentation: Meeting Point List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MeetingPointList $parameters
     * @return \StructType\MeetingPointListResponse|bool
     */
    public function MeetingPointList(\StructType\MeetingPointList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MeetingPointList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MeetingPointListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
