<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelResultModify StructType
 * @subpackage Structs
 */
class JP_HotelResultModify extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelInfo
     */
    public $HotelInfo;
    /**
     * The HotelOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelOptionModify
     */
    public $HotelOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The DestinationZone
     * @var string
     */
    public $DestinationZone;
    /**
     * The JPDCode
     * @var string
     */
    public $JPDCode;
    /**
     * Constructor method for JP_HotelResultModify
     * @uses JP_HotelResultModify::setStart()
     * @uses JP_HotelResultModify::setEnd()
     * @uses JP_HotelResultModify::setHotelInfo()
     * @uses JP_HotelResultModify::setHotelOptions()
     * @uses JP_HotelResultModify::setCode()
     * @uses JP_HotelResultModify::setJPCode()
     * @uses JP_HotelResultModify::setDestinationZone()
     * @uses JP_HotelResultModify::setJPDCode()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @param \ArrayType\ArrayOfJP_HotelOptionModify $hotelOptions
     * @param string $code
     * @param string $jPCode
     * @param string $destinationZone
     * @param string $jPDCode
     */
    public function __construct($start = null, $end = null, \StructType\JP_HotelInfo $hotelInfo = null, \ArrayType\ArrayOfJP_HotelOptionModify $hotelOptions = null, $code = null, $jPCode = null, $destinationZone = null, $jPDCode = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setHotelInfo($hotelInfo)
            ->setHotelOptions($hotelOptions)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setDestinationZone($destinationZone)
            ->setJPDCode($jPDCode);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_HotelResultModify
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_HotelResultModify
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get HotelInfo value
     * @return \StructType\JP_HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @return \StructType\JP_HotelResultModify
     */
    public function setHotelInfo(\StructType\JP_HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get HotelOptions value
     * @return \ArrayType\ArrayOfJP_HotelOptionModify|null
     */
    public function getHotelOptions()
    {
        return $this->HotelOptions;
    }
    /**
     * Set HotelOptions value
     * @param \ArrayType\ArrayOfJP_HotelOptionModify $hotelOptions
     * @return \StructType\JP_HotelResultModify
     */
    public function setHotelOptions(\ArrayType\ArrayOfJP_HotelOptionModify $hotelOptions = null)
    {
        $this->HotelOptions = $hotelOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelResultModify
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_HotelResultModify
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return string|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param string $destinationZone
     * @return \StructType\JP_HotelResultModify
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZone) && !is_string($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get JPDCode value
     * @return string|null
     */
    public function getJPDCode()
    {
        return $this->JPDCode;
    }
    /**
     * Set JPDCode value
     * @param string $jPDCode
     * @return \StructType\JP_HotelResultModify
     */
    public function setJPDCode($jPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPDCode) && !is_string($jPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jPDCode)), __LINE__);
        }
        $this->JPDCode = $jPDCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelResultModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
