<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContract StructType
 * @subpackage Structs
 */
class JP_ServiceContract extends JP_Contract
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The ProvCode
     * @var int
     */
    public $ProvCode;
    /**
     * The Code
     * @var int
     */
    public $Code;
    /**
     * The ApplicationType
     * @var string
     */
    public $ApplicationType;
    /**
     * Constructor method for JP_ServiceContract
     * @uses JP_ServiceContract::setName()
     * @uses JP_ServiceContract::setSupplier()
     * @uses JP_ServiceContract::setProvCode()
     * @uses JP_ServiceContract::setCode()
     * @uses JP_ServiceContract::setApplicationType()
     * @param string $name
     * @param \StructType\JP_Supplier $supplier
     * @param int $provCode
     * @param int $code
     * @param string $applicationType
     */
    public function __construct($name = null, \StructType\JP_Supplier $supplier = null, $provCode = null, $code = null, $applicationType = null)
    {
        $this
            ->setName($name)
            ->setSupplier($supplier)
            ->setProvCode($provCode)
            ->setCode($code)
            ->setApplicationType($applicationType);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_ServiceContract
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get ProvCode value
     * @return int|null
     */
    public function getProvCode()
    {
        return $this->ProvCode;
    }
    /**
     * Set ProvCode value
     * @param int $provCode
     * @return \StructType\JP_ServiceContract
     */
    public function setProvCode($provCode = null)
    {
        // validation for constraint: int
        if (!is_null($provCode) && !is_numeric($provCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($provCode)), __LINE__);
        }
        $this->ProvCode = $provCode;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @param string $applicationType
     * @return \StructType\JP_ServiceContract
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationType)), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
