<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_UserPermission ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_UserPermission extends AbstractStructArrayBase
{
    /**
     * The UserPermissionsList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_UserPermission[]
     */
    public $UserPermissionsList;
    /**
     * Constructor method for ArrayOfJP_UserPermission
     * @uses ArrayOfJP_UserPermission::setUserPermissionsList()
     * @param \StructType\JP_UserPermission[] $userPermissionsList
     */
    public function __construct(array $userPermissionsList = array())
    {
        $this
            ->setUserPermissionsList($userPermissionsList);
    }
    /**
     * Get UserPermissionsList value
     * @return \StructType\JP_UserPermission[]|null
     */
    public function getUserPermissionsList()
    {
        return $this->UserPermissionsList;
    }
    /**
     * Set UserPermissionsList value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_UserPermission[] $userPermissionsList
     * @return \ArrayType\ArrayOfJP_UserPermission
     */
    public function setUserPermissionsList(array $userPermissionsList = array())
    {
        foreach ($userPermissionsList as $arrayOfJP_UserPermissionUserPermissionsListItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_UserPermissionUserPermissionsListItem instanceof \StructType\JP_UserPermission) {
                throw new \InvalidArgumentException(sprintf('The UserPermissionsList property can only contain items of \StructType\JP_UserPermission, "%s" given', is_object($arrayOfJP_UserPermissionUserPermissionsListItem) ? get_class($arrayOfJP_UserPermissionUserPermissionsListItem) : gettype($arrayOfJP_UserPermissionUserPermissionsListItem)), __LINE__);
            }
        }
        $this->UserPermissionsList = $userPermissionsList;
        return $this;
    }
    /**
     * Add item to UserPermissionsList value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_UserPermission $item
     * @return \ArrayType\ArrayOfJP_UserPermission
     */
    public function addToUserPermissionsList(\StructType\JP_UserPermission $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_UserPermission) {
            throw new \InvalidArgumentException(sprintf('The UserPermissionsList property can only contain items of \StructType\JP_UserPermission, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserPermissionsList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_UserPermission|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_UserPermission|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_UserPermission|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_UserPermission|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_UserPermission|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UserPermissionsList
     */
    public function getAttributeName()
    {
        return 'UserPermissionsList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_UserPermission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
