<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PackageDate ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PackageDate extends AbstractStructArrayBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageDate[]
     */
    public $Date;
    /**
     * Constructor method for ArrayOfJP_PackageDate
     * @uses ArrayOfJP_PackageDate::setDate()
     * @param \StructType\JP_PackageDate[] $date
     */
    public function __construct(array $date = array())
    {
        $this
            ->setDate($date);
    }
    /**
     * Get Date value
     * @return \StructType\JP_PackageDate[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageDate[] $date
     * @return \ArrayType\ArrayOfJP_PackageDate
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $arrayOfJP_PackageDateDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PackageDateDateItem instanceof \StructType\JP_PackageDate) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\JP_PackageDate, "%s" given', is_object($arrayOfJP_PackageDateDateItem) ? get_class($arrayOfJP_PackageDateDateItem) : gettype($arrayOfJP_PackageDateDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageDate $item
     * @return \ArrayType\ArrayOfJP_PackageDate
     */
    public function addToDate(\StructType\JP_PackageDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageDate) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\JP_PackageDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PackageDate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PackageDate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PackageDate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PackageDate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PackageDate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Date
     */
    public function getAttributeName()
    {
        return 'Date';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PackageDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
