<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CancelRequest StructType
 * @subpackage Structs
 */
class JP_CancelRequest extends AbstractStructBase
{
    /**
     * The ReservationLocator
     * @var string
     */
    public $ReservationLocator;
    /**
     * The ItemId
     * @var int
     */
    public $ItemId;
    /**
     * The OnlyCancellationFees
     * @var bool
     */
    public $OnlyCancellationFees;
    /**
     * Constructor method for JP_CancelRequest
     * @uses JP_CancelRequest::setReservationLocator()
     * @uses JP_CancelRequest::setItemId()
     * @uses JP_CancelRequest::setOnlyCancellationFees()
     * @param string $reservationLocator
     * @param int $itemId
     * @param bool $onlyCancellationFees
     */
    public function __construct($reservationLocator = null, $itemId = null, $onlyCancellationFees = null)
    {
        $this
            ->setReservationLocator($reservationLocator)
            ->setItemId($itemId)
            ->setOnlyCancellationFees($onlyCancellationFees);
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_CancelRequest
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\JP_CancelRequest
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get OnlyCancellationFees value
     * @return bool|null
     */
    public function getOnlyCancellationFees()
    {
        return $this->OnlyCancellationFees;
    }
    /**
     * Set OnlyCancellationFees value
     * @param bool $onlyCancellationFees
     * @return \StructType\JP_CancelRequest
     */
    public function setOnlyCancellationFees($onlyCancellationFees = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyCancellationFees) && !is_bool($onlyCancellationFees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyCancellationFees)), __LINE__);
        }
        $this->OnlyCancellationFees = $onlyCancellationFees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CancelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
