<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_StayRestrictions StructType
 * @subpackage Structs
 */
class JPSOAP_StayRestrictions extends AbstractStructBase
{
    /**
     * The Application
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Application;
    /**
     * The LengthOfStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_LengthOfStay[]
     */
    public $LengthOfStay;
    /**
     * The MinNights
     * @var int
     */
    public $MinNights;
    /**
     * The MaxNights
     * @var int
     */
    public $MaxNights;
    /**
     * The ApplyToLengthStayOnly
     * @var bool
     */
    public $ApplyToLengthStayOnly;
    /**
     * Constructor method for JPSOAP_StayRestrictions
     * @uses JPSOAP_StayRestrictions::setApplication()
     * @uses JPSOAP_StayRestrictions::setLengthOfStay()
     * @uses JPSOAP_StayRestrictions::setMinNights()
     * @uses JPSOAP_StayRestrictions::setMaxNights()
     * @uses JPSOAP_StayRestrictions::setApplyToLengthStayOnly()
     * @param string $application
     * @param \StructType\JPSOAP_LengthOfStay[] $lengthOfStay
     * @param int $minNights
     * @param int $maxNights
     * @param bool $applyToLengthStayOnly
     */
    public function __construct($application = null, array $lengthOfStay = array(), $minNights = null, $maxNights = null, $applyToLengthStayOnly = null)
    {
        $this
            ->setApplication($application)
            ->setLengthOfStay($lengthOfStay)
            ->setMinNights($minNights)
            ->setMaxNights($maxNights)
            ->setApplyToLengthStayOnly($applyToLengthStayOnly);
    }
    /**
     * Get Application value
     * @return string
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @uses \EnumType\JPSOAP_StayRestrictionsApplication::valueIsValid()
     * @uses \EnumType\JPSOAP_StayRestrictionsApplication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $application
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setApplication($application = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_StayRestrictionsApplication::valueIsValid($application)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $application, implode(', ', \EnumType\JPSOAP_StayRestrictionsApplication::getValidValues())), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get LengthOfStay value
     * @return \StructType\JPSOAP_LengthOfStay[]|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * Set LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_LengthOfStay[] $lengthOfStay
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setLengthOfStay(array $lengthOfStay = array())
    {
        foreach ($lengthOfStay as $jPSOAP_StayRestrictionsLengthOfStayItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_StayRestrictionsLengthOfStayItem instanceof \StructType\JPSOAP_LengthOfStay) {
                throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of \StructType\JPSOAP_LengthOfStay, "%s" given', is_object($jPSOAP_StayRestrictionsLengthOfStayItem) ? get_class($jPSOAP_StayRestrictionsLengthOfStayItem) : gettype($jPSOAP_StayRestrictionsLengthOfStayItem)), __LINE__);
            }
        }
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Add item to LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_LengthOfStay $item
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function addToLengthOfStay(\StructType\JPSOAP_LengthOfStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_LengthOfStay) {
            throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of \StructType\JPSOAP_LengthOfStay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LengthOfStay[] = $item;
        return $this;
    }
    /**
     * Get MinNights value
     * @return int|null
     */
    public function getMinNights()
    {
        return $this->MinNights;
    }
    /**
     * Set MinNights value
     * @param int $minNights
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setMinNights($minNights = null)
    {
        // validation for constraint: int
        if (!is_null($minNights) && !is_numeric($minNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minNights)), __LINE__);
        }
        $this->MinNights = $minNights;
        return $this;
    }
    /**
     * Get MaxNights value
     * @return int|null
     */
    public function getMaxNights()
    {
        return $this->MaxNights;
    }
    /**
     * Set MaxNights value
     * @param int $maxNights
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setMaxNights($maxNights = null)
    {
        // validation for constraint: int
        if (!is_null($maxNights) && !is_numeric($maxNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNights)), __LINE__);
        }
        $this->MaxNights = $maxNights;
        return $this;
    }
    /**
     * Get ApplyToLengthStayOnly value
     * @return bool|null
     */
    public function getApplyToLengthStayOnly()
    {
        return $this->ApplyToLengthStayOnly;
    }
    /**
     * Set ApplyToLengthStayOnly value
     * @param bool $applyToLengthStayOnly
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public function setApplyToLengthStayOnly($applyToLengthStayOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyToLengthStayOnly) && !is_bool($applyToLengthStayOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($applyToLengthStayOnly)), __LINE__);
        }
        $this->ApplyToLengthStayOnly = $applyToLengthStayOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_StayRestrictions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
