<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VirtualCreditCardInfo StructType
 * @subpackage Structs
 */
class JP_VirtualCreditCardInfo extends AbstractStructBase
{
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The ValidFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidFrom;
    /**
     * The IncreaseDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IncreaseDays;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for JP_VirtualCreditCardInfo
     * @uses JP_VirtualCreditCardInfo::setCurrency()
     * @uses JP_VirtualCreditCardInfo::setValidFrom()
     * @uses JP_VirtualCreditCardInfo::setIncreaseDays()
     * @uses JP_VirtualCreditCardInfo::setEmail()
     * @param string $currency
     * @param string $validFrom
     * @param string $increaseDays
     * @param string $email
     */
    public function __construct($currency = null, $validFrom = null, $increaseDays = null, $email = null)
    {
        $this
            ->setCurrency($currency)
            ->setValidFrom($validFrom)
            ->setIncreaseDays($increaseDays)
            ->setEmail($email);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_VirtualCreditCardInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\JP_VirtualCreditCardInfo
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get IncreaseDays value
     * @return string|null
     */
    public function getIncreaseDays()
    {
        return $this->IncreaseDays;
    }
    /**
     * Set IncreaseDays value
     * @param string $increaseDays
     * @return \StructType\JP_VirtualCreditCardInfo
     */
    public function setIncreaseDays($increaseDays = null)
    {
        // validation for constraint: string
        if (!is_null($increaseDays) && !is_string($increaseDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($increaseDays)), __LINE__);
        }
        $this->IncreaseDays = $increaseDays;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_VirtualCreditCardInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_VirtualCreditCardInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
