<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelRoomCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelRoomCode extends AbstractStructArrayBase
{
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelRoomCode[]
     */
    public $Room;
    /**
     * Constructor method for ArrayOfJP_HotelRoomCode
     * @uses ArrayOfJP_HotelRoomCode::setRoom()
     * @param \StructType\JP_HotelRoomCode[] $room
     */
    public function __construct(array $room = array())
    {
        $this
            ->setRoom($room);
    }
    /**
     * Get Room value
     * @return \StructType\JP_HotelRoomCode[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoomCode[] $room
     * @return \ArrayType\ArrayOfJP_HotelRoomCode
     */
    public function setRoom(array $room = array())
    {
        foreach ($room as $arrayOfJP_HotelRoomCodeRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelRoomCodeRoomItem instanceof \StructType\JP_HotelRoomCode) {
                throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\JP_HotelRoomCode, "%s" given', is_object($arrayOfJP_HotelRoomCodeRoomItem) ? get_class($arrayOfJP_HotelRoomCodeRoomItem) : gettype($arrayOfJP_HotelRoomCodeRoomItem)), __LINE__);
            }
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoomCode $item
     * @return \ArrayType\ArrayOfJP_HotelRoomCode
     */
    public function addToRoom(\StructType\JP_HotelRoomCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelRoomCode) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of \StructType\JP_HotelRoomCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelRoomCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Room
     */
    public function getAttributeName()
    {
        return 'Room';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelRoomCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
