<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightLocator StructType
 * @subpackage Structs
 */
class JP_FlightLocator extends AbstractStructBase
{
    /**
     * The ReservationLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationLocator;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TicketCommission
     */
    public $Commission;
    /**
     * Constructor method for JP_FlightLocator
     * @uses JP_FlightLocator::setReservationLocator()
     * @uses JP_FlightLocator::setCommission()
     * @param string $reservationLocator
     * @param \StructType\JP_TicketCommission $commission
     */
    public function __construct($reservationLocator = null, \StructType\JP_TicketCommission $commission = null)
    {
        $this
            ->setReservationLocator($reservationLocator)
            ->setCommission($commission);
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_FlightLocator
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\JP_TicketCommission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\JP_TicketCommission $commission
     * @return \StructType\JP_FlightLocator
     */
    public function setCommission(\StructType\JP_TicketCommission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightLocator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
