<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentPackages StructType
 * @subpackage Structs
 */
class JP_SearchSegmentPackages extends JP_SearchSegmentBase
{
    /**
     * The CountryOfResidence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfResidence;
    /**
     * The PackageCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString7
     */
    public $PackageCodes;
    /**
     * The HotelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCategories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelCategory
     */
    public $HotelCategories;
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString6
     */
    public $Suppliers;
    /**
     * The DestinationZoneForHotel
     * @var int
     */
    public $DestinationZoneForHotel;
    /**
     * The ProductChangeType
     * @var string
     */
    public $ProductChangeType;
    /**
     * Constructor method for JP_SearchSegmentPackages
     * @uses JP_SearchSegmentPackages::setCountryOfResidence()
     * @uses JP_SearchSegmentPackages::setPackageCodes()
     * @uses JP_SearchSegmentPackages::setHotelName()
     * @uses JP_SearchSegmentPackages::setHotelCategories()
     * @uses JP_SearchSegmentPackages::setSuppliers()
     * @uses JP_SearchSegmentPackages::setDestinationZoneForHotel()
     * @uses JP_SearchSegmentPackages::setProductChangeType()
     * @param string $countryOfResidence
     * @param \ArrayType\ArrayOfString7 $packageCodes
     * @param string $hotelName
     * @param \ArrayType\ArrayOfJP_HotelCategory $hotelCategories
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @param int $destinationZoneForHotel
     * @param string $productChangeType
     */
    public function __construct($countryOfResidence = null, \ArrayType\ArrayOfString7 $packageCodes = null, $hotelName = null, \ArrayType\ArrayOfJP_HotelCategory $hotelCategories = null, \ArrayType\ArrayOfString6 $suppliers = null, $destinationZoneForHotel = null, $productChangeType = null)
    {
        $this
            ->setCountryOfResidence($countryOfResidence)
            ->setPackageCodes($packageCodes)
            ->setHotelName($hotelName)
            ->setHotelCategories($hotelCategories)
            ->setSuppliers($suppliers)
            ->setDestinationZoneForHotel($destinationZoneForHotel)
            ->setProductChangeType($productChangeType);
    }
    /**
     * Get CountryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param string $countryOfResidence
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfResidence)), __LINE__);
        }
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get PackageCodes value
     * @return \ArrayType\ArrayOfString7|null
     */
    public function getPackageCodes()
    {
        return $this->PackageCodes;
    }
    /**
     * Set PackageCodes value
     * @param \ArrayType\ArrayOfString7 $packageCodes
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setPackageCodes(\ArrayType\ArrayOfString7 $packageCodes = null)
    {
        $this->PackageCodes = $packageCodes;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCategories value
     * @return \ArrayType\ArrayOfJP_HotelCategory|null
     */
    public function getHotelCategories()
    {
        return $this->HotelCategories;
    }
    /**
     * Set HotelCategories value
     * @param \ArrayType\ArrayOfJP_HotelCategory $hotelCategories
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setHotelCategories(\ArrayType\ArrayOfJP_HotelCategory $hotelCategories = null)
    {
        $this->HotelCategories = $hotelCategories;
        return $this;
    }
    /**
     * Get Suppliers value
     * @return \ArrayType\ArrayOfString6|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setSuppliers(\ArrayType\ArrayOfString6 $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get DestinationZoneForHotel value
     * @return int|null
     */
    public function getDestinationZoneForHotel()
    {
        return $this->DestinationZoneForHotel;
    }
    /**
     * Set DestinationZoneForHotel value
     * @param int $destinationZoneForHotel
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setDestinationZoneForHotel($destinationZoneForHotel = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZoneForHotel) && !is_numeric($destinationZoneForHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZoneForHotel)), __LINE__);
        }
        $this->DestinationZoneForHotel = $destinationZoneForHotel;
        return $this;
    }
    /**
     * Get ProductChangeType value
     * @return string|null
     */
    public function getProductChangeType()
    {
        return $this->ProductChangeType;
    }
    /**
     * Set ProductChangeType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productChangeType
     * @return \StructType\JP_SearchSegmentPackages
     */
    public function setProductChangeType($productChangeType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productChangeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productChangeType, implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductChangeType = $productChangeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentPackages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
