<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString9 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString9 extends AbstractStructArrayBase
{
    /**
     * The PromoCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PromoCode;
    /**
     * Constructor method for ArrayOfString9
     * @uses ArrayOfString9::setPromoCode()
     * @param string[] $promoCode
     */
    public function __construct(array $promoCode = array())
    {
        $this
            ->setPromoCode($promoCode);
    }
    /**
     * Get PromoCode value
     * @return string[]|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @throws \InvalidArgumentException
     * @param string[] $promoCode
     * @return \ArrayType\ArrayOfString9
     */
    public function setPromoCode(array $promoCode = array())
    {
        foreach ($promoCode as $arrayOfString9PromoCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString9PromoCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The PromoCode property can only contain items of string, "%s" given', is_object($arrayOfString9PromoCodeItem) ? get_class($arrayOfString9PromoCodeItem) : gettype($arrayOfString9PromoCodeItem)), __LINE__);
            }
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Add item to PromoCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString9
     */
    public function addToPromoCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PromoCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PromoCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PromoCode
     */
    public function getAttributeName()
    {
        return 'PromoCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString9
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
