<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Airline ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Airline extends AbstractStructArrayBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Airline[]
     */
    public $Airline;
    /**
     * Constructor method for ArrayOfJP_Airline
     * @uses ArrayOfJP_Airline::setAirline()
     * @param \StructType\JP_Airline[] $airline
     */
    public function __construct(array $airline = array())
    {
        $this
            ->setAirline($airline);
    }
    /**
     * Get Airline value
     * @return \StructType\JP_Airline[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Airline[] $airline
     * @return \ArrayType\ArrayOfJP_Airline
     */
    public function setAirline(array $airline = array())
    {
        foreach ($airline as $arrayOfJP_AirlineAirlineItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_AirlineAirlineItem instanceof \StructType\JP_Airline) {
                throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \StructType\JP_Airline, "%s" given', is_object($arrayOfJP_AirlineAirlineItem) ? get_class($arrayOfJP_AirlineAirlineItem) : gettype($arrayOfJP_AirlineAirlineItem)), __LINE__);
            }
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Airline $item
     * @return \ArrayType\ArrayOfJP_Airline
     */
    public function addToAirline(\StructType\JP_Airline $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Airline) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of \StructType\JP_Airline, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Airline|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Airline|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Airline|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Airline|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Airline|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Airline
     */
    public function getAttributeName()
    {
        return 'Airline';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Airline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
