<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInt ArrayType
 * @subpackage Arrays
 */
class ArrayOfInt extends AbstractStructArrayBase
{
    /**
     * The TtaCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $TtaCode;
    /**
     * Constructor method for ArrayOfInt
     * @uses ArrayOfInt::setTtaCode()
     * @param int[] $ttaCode
     */
    public function __construct(array $ttaCode = array())
    {
        $this
            ->setTtaCode($ttaCode);
    }
    /**
     * Get TtaCode value
     * @return int[]|null
     */
    public function getTtaCode()
    {
        return $this->TtaCode;
    }
    /**
     * Set TtaCode value
     * @throws \InvalidArgumentException
     * @param int[] $ttaCode
     * @return \ArrayType\ArrayOfInt
     */
    public function setTtaCode(array $ttaCode = array())
    {
        foreach ($ttaCode as $arrayOfIntTtaCodeItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrayOfIntTtaCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The TtaCode property can only contain items of int, "%s" given', is_object($arrayOfIntTtaCodeItem) ? get_class($arrayOfIntTtaCodeItem) : gettype($arrayOfIntTtaCodeItem)), __LINE__);
            }
        }
        $this->TtaCode = $ttaCode;
        return $this;
    }
    /**
     * Add item to TtaCode value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfInt
     */
    public function addToTtaCode($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The TtaCode property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TtaCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TtaCode
     */
    public function getAttributeName()
    {
        return 'TtaCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
