<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_HotelInventoryDescriptionType EnumType
 * @subpackage Enumerations
 */
class JPSOAP_HotelInventoryDescriptionType
{
    /**
     * Constant for value 'Short'
     * @return string 'Short'
     */
    const VALUE_SHORT = 'Short';
    /**
     * Constant for value 'Long'
     * @return string 'Long'
     */
    const VALUE_LONG = 'Long';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHORT
     * @uses self::VALUE_LONG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHORT,
            self::VALUE_LONG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
