<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_IdName ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_IdName extends AbstractStructArrayBase
{
    /**
     * The DirectPaymentCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_IdName[]
     */
    public $DirectPaymentCardType;
    /**
     * Constructor method for ArrayOfJPSOAP_IdName
     * @uses ArrayOfJPSOAP_IdName::setDirectPaymentCardType()
     * @param \StructType\JPSOAP_IdName[] $directPaymentCardType
     */
    public function __construct(array $directPaymentCardType = array())
    {
        $this
            ->setDirectPaymentCardType($directPaymentCardType);
    }
    /**
     * Get DirectPaymentCardType value
     * @return \StructType\JPSOAP_IdName[]|null
     */
    public function getDirectPaymentCardType()
    {
        return $this->DirectPaymentCardType;
    }
    /**
     * Set DirectPaymentCardType value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_IdName[] $directPaymentCardType
     * @return \ArrayType\ArrayOfJPSOAP_IdName
     */
    public function setDirectPaymentCardType(array $directPaymentCardType = array())
    {
        foreach ($directPaymentCardType as $arrayOfJPSOAP_IdNameDirectPaymentCardTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_IdNameDirectPaymentCardTypeItem instanceof \StructType\JPSOAP_IdName) {
                throw new \InvalidArgumentException(sprintf('The DirectPaymentCardType property can only contain items of \StructType\JPSOAP_IdName, "%s" given', is_object($arrayOfJPSOAP_IdNameDirectPaymentCardTypeItem) ? get_class($arrayOfJPSOAP_IdNameDirectPaymentCardTypeItem) : gettype($arrayOfJPSOAP_IdNameDirectPaymentCardTypeItem)), __LINE__);
            }
        }
        $this->DirectPaymentCardType = $directPaymentCardType;
        return $this;
    }
    /**
     * Add item to DirectPaymentCardType value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_IdName $item
     * @return \ArrayType\ArrayOfJPSOAP_IdName
     */
    public function addToDirectPaymentCardType(\StructType\JPSOAP_IdName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_IdName) {
            throw new \InvalidArgumentException(sprintf('The DirectPaymentCardType property can only contain items of \StructType\JPSOAP_IdName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DirectPaymentCardType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_IdName|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_IdName|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_IdName|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_IdName|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_IdName|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DirectPaymentCardType
     */
    public function getAttributeName()
    {
        return 'DirectPaymentCardType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_IdName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
