<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString8 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString8 extends AbstractStructArrayBase
{
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $HotelCode;
    /**
     * Constructor method for ArrayOfString8
     * @uses ArrayOfString8::setHotelCode()
     * @param string[] $hotelCode
     */
    public function __construct(array $hotelCode = array())
    {
        $this
            ->setHotelCode($hotelCode);
    }
    /**
     * Get HotelCode value
     * @return string[]|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @throws \InvalidArgumentException
     * @param string[] $hotelCode
     * @return \ArrayType\ArrayOfString8
     */
    public function setHotelCode(array $hotelCode = array())
    {
        foreach ($hotelCode as $arrayOfString8HotelCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString8HotelCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The HotelCode property can only contain items of string, "%s" given', is_object($arrayOfString8HotelCodeItem) ? get_class($arrayOfString8HotelCodeItem) : gettype($arrayOfString8HotelCodeItem)), __LINE__);
            }
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Add item to HotelCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString8
     */
    public function addToHotelCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The HotelCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelCode
     */
    public function getAttributeName()
    {
        return 'HotelCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfString8
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
