<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Fax ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Fax extends AbstractStructArrayBase
{
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Fax[]
     */
    public $Fax;
    /**
     * Constructor method for ArrayOfJP_Fax
     * @uses ArrayOfJP_Fax::setFax()
     * @param \StructType\JP_Fax[] $fax
     */
    public function __construct(array $fax = array())
    {
        $this
            ->setFax($fax);
    }
    /**
     * Get Fax value
     * @return \StructType\JP_Fax[]|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Fax[] $fax
     * @return \ArrayType\ArrayOfJP_Fax
     */
    public function setFax(array $fax = array())
    {
        foreach ($fax as $arrayOfJP_FaxFaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FaxFaxItem instanceof \StructType\JP_Fax) {
                throw new \InvalidArgumentException(sprintf('The Fax property can only contain items of \StructType\JP_Fax, "%s" given', is_object($arrayOfJP_FaxFaxItem) ? get_class($arrayOfJP_FaxFaxItem) : gettype($arrayOfJP_FaxFaxItem)), __LINE__);
            }
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Add item to Fax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Fax $item
     * @return \ArrayType\ArrayOfJP_Fax
     */
    public function addToFax(\StructType\JP_Fax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Fax) {
            throw new \InvalidArgumentException(sprintf('The Fax property can only contain items of \StructType\JP_Fax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Fax|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Fax|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Fax|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Fax|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Fax|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fax
     */
    public function getAttributeName()
    {
        return 'Fax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Fax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
