<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageStay StructType
 * @subpackage Structs
 */
class JP_PackageStay extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Hotels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageHotel
     */
    public $Hotels;
    /**
     * The Flights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Flight
     */
    public $Flights;
    /**
     * The Transfers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Transfer
     */
    public $Transfers;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceProduct
     */
    public $Services;
    /**
     * The Insurances
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageInsurance
     */
    public $Insurances;
    /**
     * The Packages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Tour
     */
    public $Packages;
    /**
     * The Rentacars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Car
     */
    public $Rentacars;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * Constructor method for JP_PackageStay
     * @uses JP_PackageStay::setStart()
     * @uses JP_PackageStay::setEnd()
     * @uses JP_PackageStay::setHotels()
     * @uses JP_PackageStay::setFlights()
     * @uses JP_PackageStay::setTransfers()
     * @uses JP_PackageStay::setServices()
     * @uses JP_PackageStay::setInsurances()
     * @uses JP_PackageStay::setPackages()
     * @uses JP_PackageStay::setRentacars()
     * @uses JP_PackageStay::setCode()
     * @uses JP_PackageStay::setDestinationZone()
     * @param string $start
     * @param string $end
     * @param \ArrayType\ArrayOfJP_PackageHotel $hotels
     * @param \ArrayType\ArrayOfJP_Flight $flights
     * @param \ArrayType\ArrayOfJP_Transfer $transfers
     * @param \ArrayType\ArrayOfJP_ServiceProduct $services
     * @param \ArrayType\ArrayOfJP_PackageInsurance $insurances
     * @param \ArrayType\ArrayOfJP_Tour $packages
     * @param \ArrayType\ArrayOfJP_Car $rentacars
     * @param string $code
     * @param int $destinationZone
     */
    public function __construct($start = null, $end = null, \ArrayType\ArrayOfJP_PackageHotel $hotels = null, \ArrayType\ArrayOfJP_Flight $flights = null, \ArrayType\ArrayOfJP_Transfer $transfers = null, \ArrayType\ArrayOfJP_ServiceProduct $services = null, \ArrayType\ArrayOfJP_PackageInsurance $insurances = null, \ArrayType\ArrayOfJP_Tour $packages = null, \ArrayType\ArrayOfJP_Car $rentacars = null, $code = null, $destinationZone = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setHotels($hotels)
            ->setFlights($flights)
            ->setTransfers($transfers)
            ->setServices($services)
            ->setInsurances($insurances)
            ->setPackages($packages)
            ->setRentacars($rentacars)
            ->setCode($code)
            ->setDestinationZone($destinationZone);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_PackageStay
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageStay
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Hotels value
     * @return \ArrayType\ArrayOfJP_PackageHotel|null
     */
    public function getHotels()
    {
        return $this->Hotels;
    }
    /**
     * Set Hotels value
     * @param \ArrayType\ArrayOfJP_PackageHotel $hotels
     * @return \StructType\JP_PackageStay
     */
    public function setHotels(\ArrayType\ArrayOfJP_PackageHotel $hotels = null)
    {
        $this->Hotels = $hotels;
        return $this;
    }
    /**
     * Get Flights value
     * @return \ArrayType\ArrayOfJP_Flight|null
     */
    public function getFlights()
    {
        return $this->Flights;
    }
    /**
     * Set Flights value
     * @param \ArrayType\ArrayOfJP_Flight $flights
     * @return \StructType\JP_PackageStay
     */
    public function setFlights(\ArrayType\ArrayOfJP_Flight $flights = null)
    {
        $this->Flights = $flights;
        return $this;
    }
    /**
     * Get Transfers value
     * @return \ArrayType\ArrayOfJP_Transfer|null
     */
    public function getTransfers()
    {
        return $this->Transfers;
    }
    /**
     * Set Transfers value
     * @param \ArrayType\ArrayOfJP_Transfer $transfers
     * @return \StructType\JP_PackageStay
     */
    public function setTransfers(\ArrayType\ArrayOfJP_Transfer $transfers = null)
    {
        $this->Transfers = $transfers;
        return $this;
    }
    /**
     * Get Services value
     * @return \ArrayType\ArrayOfJP_ServiceProduct|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \ArrayType\ArrayOfJP_ServiceProduct $services
     * @return \StructType\JP_PackageStay
     */
    public function setServices(\ArrayType\ArrayOfJP_ServiceProduct $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get Insurances value
     * @return \ArrayType\ArrayOfJP_PackageInsurance|null
     */
    public function getInsurances()
    {
        return $this->Insurances;
    }
    /**
     * Set Insurances value
     * @param \ArrayType\ArrayOfJP_PackageInsurance $insurances
     * @return \StructType\JP_PackageStay
     */
    public function setInsurances(\ArrayType\ArrayOfJP_PackageInsurance $insurances = null)
    {
        $this->Insurances = $insurances;
        return $this;
    }
    /**
     * Get Packages value
     * @return \ArrayType\ArrayOfJP_Tour|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \ArrayType\ArrayOfJP_Tour $packages
     * @return \StructType\JP_PackageStay
     */
    public function setPackages(\ArrayType\ArrayOfJP_Tour $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get Rentacars value
     * @return \ArrayType\ArrayOfJP_Car|null
     */
    public function getRentacars()
    {
        return $this->Rentacars;
    }
    /**
     * Set Rentacars value
     * @param \ArrayType\ArrayOfJP_Car $rentacars
     * @return \StructType\JP_PackageStay
     */
    public function setRentacars(\ArrayType\ArrayOfJP_Car $rentacars = null)
    {
        $this->Rentacars = $rentacars;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageStay
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageStay
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !is_numeric($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
