<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FreeNights StructType
 * @subpackage Structs
 */
class JP_FreeNights extends AbstractStructBase
{
    /**
     * The Nights
     * @var int
     */
    public $Nights;
    /**
     * The Free
     * @var int
     */
    public $Free;
    /**
     * Constructor method for JP_FreeNights
     * @uses JP_FreeNights::setNights()
     * @uses JP_FreeNights::setFree()
     * @param int $nights
     * @param int $free
     */
    public function __construct($nights = null, $free = null)
    {
        $this
            ->setNights($nights)
            ->setFree($free);
    }
    /**
     * Get Nights value
     * @return int|null
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \StructType\JP_FreeNights
     */
    public function setNights($nights = null)
    {
        // validation for constraint: int
        if (!is_null($nights) && !is_numeric($nights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nights)), __LINE__);
        }
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Free value
     * @return int|null
     */
    public function getFree()
    {
        return $this->Free;
    }
    /**
     * Set Free value
     * @param int $free
     * @return \StructType\JP_FreeNights
     */
    public function setFree($free = null)
    {
        // validation for constraint: int
        if (!is_null($free) && !is_numeric($free)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($free)), __LINE__);
        }
        $this->Free = $free;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FreeNights
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
