<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Bag StructType
 * @subpackage Structs
 */
class JP_Bag extends AbstractStructBase
{
    /**
     * The BaggageType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BaggageType;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Quantity;
    /**
     * The RelPaxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ExtendedRelPaxBag
     */
    public $RelPaxes;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Price
     */
    public $Price;
    /**
     * The Descriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString3
     */
    public $Descriptions;
    /**
     * The Weight
     * @var int
     */
    public $Weight;
    /**
     * The Size
     * @var string
     */
    public $Size;
    /**
     * Constructor method for JP_Bag
     * @uses JP_Bag::setBaggageType()
     * @uses JP_Bag::setQuantity()
     * @uses JP_Bag::setRelPaxes()
     * @uses JP_Bag::setPrice()
     * @uses JP_Bag::setDescriptions()
     * @uses JP_Bag::setWeight()
     * @uses JP_Bag::setSize()
     * @param string $baggageType
     * @param int $quantity
     * @param \ArrayType\ArrayOfJP_ExtendedRelPaxBag $relPaxes
     * @param \StructType\JP_Price $price
     * @param \ArrayType\ArrayOfString3 $descriptions
     * @param int $weight
     * @param string $size
     */
    public function __construct($baggageType = null, $quantity = null, \ArrayType\ArrayOfJP_ExtendedRelPaxBag $relPaxes = null, \StructType\JP_Price $price = null, \ArrayType\ArrayOfString3 $descriptions = null, $weight = null, $size = null)
    {
        $this
            ->setBaggageType($baggageType)
            ->setQuantity($quantity)
            ->setRelPaxes($relPaxes)
            ->setPrice($price)
            ->setDescriptions($descriptions)
            ->setWeight($weight)
            ->setSize($size);
    }
    /**
     * Get BaggageType value
     * @return string
     */
    public function getBaggageType()
    {
        return $this->BaggageType;
    }
    /**
     * Set BaggageType value
     * @uses \EnumType\JP_BaggageType::valueIsValid()
     * @uses \EnumType\JP_BaggageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baggageType
     * @return \StructType\JP_Bag
     */
    public function setBaggageType($baggageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_BaggageType::valueIsValid($baggageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $baggageType, implode(', ', \EnumType\JP_BaggageType::getValidValues())), __LINE__);
        }
        $this->BaggageType = $baggageType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\JP_Bag
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_ExtendedRelPaxBag|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_ExtendedRelPaxBag $relPaxes
     * @return \StructType\JP_Bag
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_ExtendedRelPaxBag $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_Price $price
     * @return \StructType\JP_Bag
     */
    public function setPrice(\StructType\JP_Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfString3|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfString3 $descriptions
     * @return \StructType\JP_Bag
     */
    public function setDescriptions(\ArrayType\ArrayOfString3 $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\JP_Bag
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\JP_Bag
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Bag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
