<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cruise ServiceType
 * @subpackage Services
 */
class Cruise extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CruiseBooking
     * Meta informations extracted from the WSDL
     * - documentation: Booking for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseBooking $parameters
     * @return \StructType\CruiseBookingResponse|bool
     */
    public function CruiseBooking(\StructType\CruiseBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruisePreAvail
     * Meta informations extracted from the WSDL
     * - documentation: Pre-Availability for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruisePreAvail $parameters
     * @return \StructType\CruisePreAvailResponse|bool
     */
    public function CruisePreAvail(\StructType\CruisePreAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruisePreAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseAvail
     * Meta informations extracted from the WSDL
     * - documentation: Availability for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseAvail $parameters
     * @return \StructType\CruiseAvailResponse|bool
     */
    public function CruiseAvail(\StructType\CruiseAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseItinerary
     * Meta informations extracted from the WSDL
     * - documentation: List of itineraries.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseItinerary $parameters
     * @return \StructType\CruiseItineraryResponse|bool
     */
    public function CruiseItinerary(\StructType\CruiseItinerary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseItinerary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseShip
     * Meta informations extracted from the WSDL
     * - documentation: List of ships.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseShip $parameters
     * @return \StructType\CruiseShipResponse|bool
     */
    public function CruiseShip(\StructType\CruiseShip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseShip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseDataList
     * Meta informations extracted from the WSDL
     * - documentation: List of Cruises Data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseDataList $parameters
     * @return \StructType\CruiseDataListResponse|bool
     */
    public function CruiseDataList(\StructType\CruiseDataList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseCheckAvail
     * Meta informations extracted from the WSDL
     * - documentation: CheckAvail for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseCheckAvail $parameters
     * @return \StructType\CruiseCheckAvailResponse|bool
     */
    public function CruiseCheckAvail(\StructType\CruiseCheckAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseBookingRules
     * Meta informations extracted from the WSDL
     * - documentation: BookingRules of cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseBookingRules $parameters
     * @return \StructType\CruiseBookingRulesResponse|bool
     */
    public function CruiseBookingRules(\StructType\CruiseBookingRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CruiseBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CruiseAvailResponse|\StructType\CruiseBookingResponse|\StructType\CruiseBookingRulesResponse|\StructType\CruiseCheckAvailResponse|\StructType\CruiseDataListResponse|\StructType\CruiseItineraryResponse|\StructType\CruisePreAvailResponse|\StructType\CruiseShipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
