<?php

namespace EnumType;

/**
 * This class stands for JP_HotelRoomSizeUnitType EnumType
 * @subpackage Enumerations
 */
class JP_HotelRoomSizeUnitType
{
    /**
     * Constant for value 'ft2'
     * @return string 'ft2'
     */
    const VALUE_FT_2 = 'ft2';
    /**
     * Constant for value 'm2'
     * @return string 'm2'
     */
    const VALUE_M_2 = 'm2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FT_2
     * @uses self::VALUE_M_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FT_2,
            self::VALUE_M_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
