<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelInventoryCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelInventoryCode extends AbstractStructArrayBase
{
    /**
     * The HotelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelInventoryCode[]
     */
    public $HotelCode;
    /**
     * Constructor method for ArrayOfJP_HotelInventoryCode
     * @uses ArrayOfJP_HotelInventoryCode::setHotelCode()
     * @param \StructType\JP_HotelInventoryCode[] $hotelCode
     */
    public function __construct(array $hotelCode = array())
    {
        $this
            ->setHotelCode($hotelCode);
    }
    /**
     * Get HotelCode value
     * @return \StructType\JP_HotelInventoryCode[]|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelInventoryCode[] $hotelCode
     * @return \ArrayType\ArrayOfJP_HotelInventoryCode
     */
    public function setHotelCode(array $hotelCode = array())
    {
        foreach ($hotelCode as $arrayOfJP_HotelInventoryCodeHotelCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelInventoryCodeHotelCodeItem instanceof \StructType\JP_HotelInventoryCode) {
                throw new \InvalidArgumentException(sprintf('The HotelCode property can only contain items of \StructType\JP_HotelInventoryCode, "%s" given', is_object($arrayOfJP_HotelInventoryCodeHotelCodeItem) ? get_class($arrayOfJP_HotelInventoryCodeHotelCodeItem) : gettype($arrayOfJP_HotelInventoryCodeHotelCodeItem)), __LINE__);
            }
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Add item to HotelCode value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelInventoryCode $item
     * @return \ArrayType\ArrayOfJP_HotelInventoryCode
     */
    public function addToHotelCode(\StructType\JP_HotelInventoryCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelInventoryCode) {
            throw new \InvalidArgumentException(sprintf('The HotelCode property can only contain items of \StructType\JP_HotelInventoryCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelInventoryCode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelInventoryCode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelInventoryCode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelInventoryCode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelInventoryCode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelCode
     */
    public function getAttributeName()
    {
        return 'HotelCode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelInventoryCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
