<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CruisePromotion ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CruisePromotion extends AbstractStructArrayBase
{
    /**
     * The Promotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruisePromotion[]
     */
    public $Promotion;
    /**
     * Constructor method for ArrayOfJP_CruisePromotion
     * @uses ArrayOfJP_CruisePromotion::setPromotion()
     * @param \StructType\JP_CruisePromotion[] $promotion
     */
    public function __construct(array $promotion = array())
    {
        $this
            ->setPromotion($promotion);
    }
    /**
     * Get Promotion value
     * @return \StructType\JP_CruisePromotion[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruisePromotion[] $promotion
     * @return \ArrayType\ArrayOfJP_CruisePromotion
     */
    public function setPromotion(array $promotion = array())
    {
        foreach ($promotion as $arrayOfJP_CruisePromotionPromotionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CruisePromotionPromotionItem instanceof \StructType\JP_CruisePromotion) {
                throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of \StructType\JP_CruisePromotion, "%s" given', is_object($arrayOfJP_CruisePromotionPromotionItem) ? get_class($arrayOfJP_CruisePromotionPromotionItem) : gettype($arrayOfJP_CruisePromotionPromotionItem)), __LINE__);
            }
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruisePromotion $item
     * @return \ArrayType\ArrayOfJP_CruisePromotion
     */
    public function addToPromotion(\StructType\JP_CruisePromotion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruisePromotion) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of \StructType\JP_CruisePromotion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CruisePromotion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CruisePromotion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CruisePromotion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CruisePromotion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CruisePromotion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Promotion
     */
    public function getAttributeName()
    {
        return 'Promotion';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CruisePromotion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
