<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CruiseData ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CruiseData extends AbstractStructArrayBase
{
    /**
     * The CruiseData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseData[]
     */
    public $CruiseData;
    /**
     * Constructor method for ArrayOfJP_CruiseData
     * @uses ArrayOfJP_CruiseData::setCruiseData()
     * @param \StructType\JP_CruiseData[] $cruiseData
     */
    public function __construct(array $cruiseData = array())
    {
        $this
            ->setCruiseData($cruiseData);
    }
    /**
     * Get CruiseData value
     * @return \StructType\JP_CruiseData[]|null
     */
    public function getCruiseData()
    {
        return $this->CruiseData;
    }
    /**
     * Set CruiseData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseData[] $cruiseData
     * @return \ArrayType\ArrayOfJP_CruiseData
     */
    public function setCruiseData(array $cruiseData = array())
    {
        foreach ($cruiseData as $arrayOfJP_CruiseDataCruiseDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CruiseDataCruiseDataItem instanceof \StructType\JP_CruiseData) {
                throw new \InvalidArgumentException(sprintf('The CruiseData property can only contain items of \StructType\JP_CruiseData, "%s" given', is_object($arrayOfJP_CruiseDataCruiseDataItem) ? get_class($arrayOfJP_CruiseDataCruiseDataItem) : gettype($arrayOfJP_CruiseDataCruiseDataItem)), __LINE__);
            }
        }
        $this->CruiseData = $cruiseData;
        return $this;
    }
    /**
     * Add item to CruiseData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseData $item
     * @return \ArrayType\ArrayOfJP_CruiseData
     */
    public function addToCruiseData(\StructType\JP_CruiseData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseData) {
            throw new \InvalidArgumentException(sprintf('The CruiseData property can only contain items of \StructType\JP_CruiseData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CruiseData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CruiseData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CruiseData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CruiseData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CruiseData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CruiseData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CruiseData
     */
    public function getAttributeName()
    {
        return 'CruiseData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CruiseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
