<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransportBookingRules StructType
 * @subpackage Structs
 */
class JP_TransportBookingRules extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The LowCost
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $LowCost;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The TransportRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransportRequiredFields
     */
    public $TransportRequiredFields;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The AdditionalPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AdditionalPoliciesGroup
     */
    public $AdditionalPolicies;
    /**
     * The PriceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransportPriceInformation
     */
    public $PriceInformation;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalElements
     */
    public $OptionalElements;
    /**
     * The FareGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FareGroup
     */
    public $FareGroup;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The Additionalnformation
     * @var string
     */
    public $Additionalnformation;
    /**
     * Constructor method for JP_TransportBookingRules
     * @uses JP_TransportBookingRules::setStatus()
     * @uses JP_TransportBookingRules::setLowCost()
     * @uses JP_TransportBookingRules::setBookingCode()
     * @uses JP_TransportBookingRules::setTransportRequiredFields()
     * @uses JP_TransportBookingRules::setCancellationPolicy()
     * @uses JP_TransportBookingRules::setCancellationPolicyCost()
     * @uses JP_TransportBookingRules::setAdditionalPolicies()
     * @uses JP_TransportBookingRules::setPriceInformation()
     * @uses JP_TransportBookingRules::setOptionalElements()
     * @uses JP_TransportBookingRules::setFareGroup()
     * @uses JP_TransportBookingRules::setSource()
     * @uses JP_TransportBookingRules::setDirection()
     * @uses JP_TransportBookingRules::setAdditionalnformation()
     * @param string $status
     * @param bool $lowCost
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_TransportRequiredFields $transportRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies
     * @param \StructType\JP_TransportPriceInformation $priceInformation
     * @param \StructType\JP_OptionalElements $optionalElements
     * @param \StructType\JP_FareGroup $fareGroup
     * @param string $source
     * @param string $direction
     * @param string $additionalnformation
     */
    public function __construct($status = null, $lowCost = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_TransportRequiredFields $transportRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies = null, \StructType\JP_TransportPriceInformation $priceInformation = null, \StructType\JP_OptionalElements $optionalElements = null, \StructType\JP_FareGroup $fareGroup = null, $source = null, $direction = null, $additionalnformation = null)
    {
        $this
            ->setStatus($status)
            ->setLowCost($lowCost)
            ->setBookingCode($bookingCode)
            ->setTransportRequiredFields($transportRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setAdditionalPolicies($additionalPolicies)
            ->setPriceInformation($priceInformation)
            ->setOptionalElements($optionalElements)
            ->setFareGroup($fareGroup)
            ->setSource($source)
            ->setDirection($direction)
            ->setAdditionalnformation($additionalnformation);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_TransportBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_TransportBookingRules
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowCost, true), gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_TransportBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get TransportRequiredFields value
     * @return \StructType\JP_TransportRequiredFields|null
     */
    public function getTransportRequiredFields()
    {
        return $this->TransportRequiredFields;
    }
    /**
     * Set TransportRequiredFields value
     * @param \StructType\JP_TransportRequiredFields $transportRequiredFields
     * @return \StructType\JP_TransportBookingRules
     */
    public function setTransportRequiredFields(\StructType\JP_TransportRequiredFields $transportRequiredFields = null)
    {
        $this->TransportRequiredFields = $transportRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_TransportBookingRules
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_TransportBookingRules
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get AdditionalPolicies value
     * @return \ArrayType\ArrayOfJP_AdditionalPoliciesGroup|null
     */
    public function getAdditionalPolicies()
    {
        return $this->AdditionalPolicies;
    }
    /**
     * Set AdditionalPolicies value
     * @param \ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies
     * @return \StructType\JP_TransportBookingRules
     */
    public function setAdditionalPolicies(\ArrayType\ArrayOfJP_AdditionalPoliciesGroup $additionalPolicies = null)
    {
        $this->AdditionalPolicies = $additionalPolicies;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_TransportPriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_TransportPriceInformation $priceInformation
     * @return \StructType\JP_TransportBookingRules
     */
    public function setPriceInformation(\StructType\JP_TransportPriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_OptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_OptionalElements $optionalElements
     * @return \StructType\JP_TransportBookingRules
     */
    public function setOptionalElements(\StructType\JP_OptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get FareGroup value
     * @return \StructType\JP_FareGroup|null
     */
    public function getFareGroup()
    {
        return $this->FareGroup;
    }
    /**
     * Set FareGroup value
     * @param \StructType\JP_FareGroup $fareGroup
     * @return \StructType\JP_TransportBookingRules
     */
    public function setFareGroup(\StructType\JP_FareGroup $fareGroup = null)
    {
        $this->FareGroup = $fareGroup;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_TransportBookingRules
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_TransportBookingRules
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Additionalnformation value
     * @return string|null
     */
    public function getAdditionalnformation()
    {
        return $this->Additionalnformation;
    }
    /**
     * Set Additionalnformation value
     * @param string $additionalnformation
     * @return \StructType\JP_TransportBookingRules
     */
    public function setAdditionalnformation($additionalnformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalnformation) && !is_string($additionalnformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalnformation, true), gettype($additionalnformation)), __LINE__);
        }
        $this->Additionalnformation = $additionalnformation;
        return $this;
    }
}
