<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingHotelPoint StructType
 * @subpackage Structs
 */
class JP_MeetingHotelPoint extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The MeetingPointCode
     * @var string
     */
    public $MeetingPointCode;
    /**
     * The Address
     * @var string
     */
    public $Address;
    /**
     * Constructor method for JP_MeetingHotelPoint
     * @uses JP_MeetingHotelPoint::setName()
     * @uses JP_MeetingHotelPoint::setCode()
     * @uses JP_MeetingHotelPoint::setJPCode()
     * @uses JP_MeetingHotelPoint::setMeetingPointCode()
     * @uses JP_MeetingHotelPoint::setAddress()
     * @param string $name
     * @param string $code
     * @param string $jPCode
     * @param string $meetingPointCode
     * @param string $address
     */
    public function __construct($name = null, $code = null, $jPCode = null, $meetingPointCode = null, $address = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setMeetingPointCode($meetingPointCode)
            ->setAddress($address);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_MeetingHotelPoint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_MeetingHotelPoint
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_MeetingHotelPoint
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get MeetingPointCode value
     * @return string|null
     */
    public function getMeetingPointCode()
    {
        return $this->MeetingPointCode;
    }
    /**
     * Set MeetingPointCode value
     * @param string $meetingPointCode
     * @return \StructType\JP_MeetingHotelPoint
     */
    public function setMeetingPointCode($meetingPointCode = null)
    {
        // validation for constraint: string
        if (!is_null($meetingPointCode) && !is_string($meetingPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingPointCode, true), gettype($meetingPointCode)), __LINE__);
        }
        $this->MeetingPointCode = $meetingPointCode;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_MeetingHotelPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
}
