<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CarSupplement StructType
 * @subpackage Structs
 */
class JP_CarSupplement extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The SupplementRelPaxesDist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_SupplementRelPaxDist
     */
    public $SupplementRelPaxesDist;
    /**
     * The PriceType
     * @var int
     */
    public $PriceType;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Units
     * @var int
     */
    public $Units;
    /**
     * The UntMin
     * @var int
     */
    public $UntMin;
    /**
     * The UntMax
     * @var int
     */
    public $UntMax;
    /**
     * The PaymentOffice
     * @var bool
     */
    public $PaymentOffice;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CarSupplement
     * @uses JP_CarSupplement::setStatus()
     * @uses JP_CarSupplement::setName()
     * @uses JP_CarSupplement::setDescription()
     * @uses JP_CarSupplement::setPrices()
     * @uses JP_CarSupplement::setSupplementRelPaxesDist()
     * @uses JP_CarSupplement::setPriceType()
     * @uses JP_CarSupplement::setCode()
     * @uses JP_CarSupplement::setUnits()
     * @uses JP_CarSupplement::setUntMin()
     * @uses JP_CarSupplement::setUntMax()
     * @uses JP_CarSupplement::setPaymentOffice()
     * @uses JP_CarSupplement::setAmount()
     * @uses JP_CarSupplement::setCurrency()
     * @uses JP_CarSupplement::setRatePlanCode()
     * @param string $status
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist
     * @param int $priceType
     * @param string $code
     * @param int $units
     * @param int $untMin
     * @param int $untMax
     * @param bool $paymentOffice
     * @param float $amount
     * @param string $currency
     * @param string $ratePlanCode
     */
    public function __construct($status = null, $name = null, $description = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist = null, $priceType = null, $code = null, $units = null, $untMin = null, $untMax = null, $paymentOffice = null, $amount = null, $currency = null, $ratePlanCode = null)
    {
        $this
            ->setStatus($status)
            ->setName($name)
            ->setDescription($description)
            ->setPrices($prices)
            ->setSupplementRelPaxesDist($supplementRelPaxesDist)
            ->setPriceType($priceType)
            ->setCode($code)
            ->setUnits($units)
            ->setUntMin($untMin)
            ->setUntMax($untMax)
            ->setPaymentOffice($paymentOffice)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_CarSupplement
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CarSupplement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_CarSupplement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_CarSupplement
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get SupplementRelPaxesDist value
     * @return \ArrayType\ArrayOfJP_SupplementRelPaxDist|null
     */
    public function getSupplementRelPaxesDist()
    {
        return $this->SupplementRelPaxesDist;
    }
    /**
     * Set SupplementRelPaxesDist value
     * @param \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist
     * @return \StructType\JP_CarSupplement
     */
    public function setSupplementRelPaxesDist(\ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist = null)
    {
        $this->SupplementRelPaxesDist = $supplementRelPaxesDist;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int|null
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\JP_CarSupplement
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !(is_int($priceType) || ctype_digit($priceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CarSupplement
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Units value
     * @return int|null
     */
    public function getUnits()
    {
        return $this->Units;
    }
    /**
     * Set Units value
     * @param int $units
     * @return \StructType\JP_CarSupplement
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !(is_int($units) || ctype_digit($units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->Units = $units;
        return $this;
    }
    /**
     * Get UntMin value
     * @return int|null
     */
    public function getUntMin()
    {
        return $this->UntMin;
    }
    /**
     * Set UntMin value
     * @param int $untMin
     * @return \StructType\JP_CarSupplement
     */
    public function setUntMin($untMin = null)
    {
        // validation for constraint: int
        if (!is_null($untMin) && !(is_int($untMin) || ctype_digit($untMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untMin, true), gettype($untMin)), __LINE__);
        }
        $this->UntMin = $untMin;
        return $this;
    }
    /**
     * Get UntMax value
     * @return int|null
     */
    public function getUntMax()
    {
        return $this->UntMax;
    }
    /**
     * Set UntMax value
     * @param int $untMax
     * @return \StructType\JP_CarSupplement
     */
    public function setUntMax($untMax = null)
    {
        // validation for constraint: int
        if (!is_null($untMax) && !(is_int($untMax) || ctype_digit($untMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($untMax, true), gettype($untMax)), __LINE__);
        }
        $this->UntMax = $untMax;
        return $this;
    }
    /**
     * Get PaymentOffice value
     * @return bool|null
     */
    public function getPaymentOffice()
    {
        return $this->PaymentOffice;
    }
    /**
     * Set PaymentOffice value
     * @param bool $paymentOffice
     * @return \StructType\JP_CarSupplement
     */
    public function setPaymentOffice($paymentOffice = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentOffice) && !is_bool($paymentOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentOffice, true), gettype($paymentOffice)), __LINE__);
        }
        $this->PaymentOffice = $paymentOffice;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_CarSupplement
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_CarSupplement
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CarSupplement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
}
