<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_SpecialNote ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_SpecialNote extends AbstractStructArrayBase
{
    /**
     * The SpecialNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_SpecialNote[]
     */
    public $SpecialNote;
    /**
     * Constructor method for ArrayOfJP_SpecialNote
     * @uses ArrayOfJP_SpecialNote::setSpecialNote()
     * @param \StructType\JP_SpecialNote[] $specialNote
     */
    public function __construct(array $specialNote = array())
    {
        $this
            ->setSpecialNote($specialNote);
    }
    /**
     * Get SpecialNote value
     * @return \StructType\JP_SpecialNote[]|null
     */
    public function getSpecialNote()
    {
        return $this->SpecialNote;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialNoteForArrayConstraintsFromSetSpecialNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_SpecialNoteSpecialNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_SpecialNoteSpecialNoteItem instanceof \StructType\JP_SpecialNote) {
                $invalidValues[] = is_object($arrayOfJP_SpecialNoteSpecialNoteItem) ? get_class($arrayOfJP_SpecialNoteSpecialNoteItem) : sprintf('%s(%s)', gettype($arrayOfJP_SpecialNoteSpecialNoteItem), var_export($arrayOfJP_SpecialNoteSpecialNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialNote property can only contain items of type \StructType\JP_SpecialNote, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialNote value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_SpecialNote[] $specialNote
     * @return \ArrayType\ArrayOfJP_SpecialNote
     */
    public function setSpecialNote(array $specialNote = array())
    {
        // validation for constraint: array
        if ('' !== ($specialNoteArrayErrorMessage = self::validateSpecialNoteForArrayConstraintsFromSetSpecialNote($specialNote))) {
            throw new \InvalidArgumentException($specialNoteArrayErrorMessage, __LINE__);
        }
        $this->SpecialNote = $specialNote;
        return $this;
    }
    /**
     * Add item to SpecialNote value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_SpecialNote $item
     * @return \ArrayType\ArrayOfJP_SpecialNote
     */
    public function addToSpecialNote(\StructType\JP_SpecialNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_SpecialNote) {
            throw new \InvalidArgumentException(sprintf('The SpecialNote property can only contain items of type \StructType\JP_SpecialNote, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_SpecialNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_SpecialNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_SpecialNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_SpecialNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_SpecialNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialNote
     */
    public function getAttributeName()
    {
        return 'SpecialNote';
    }
}
