<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ExternalDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ExternalDocument extends AbstractStructArrayBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ExternalDocument[]
     */
    public $Document;
    /**
     * Constructor method for ArrayOfJP_ExternalDocument
     * @uses ArrayOfJP_ExternalDocument::setDocument()
     * @param \StructType\JP_ExternalDocument[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get Document value
     * @return \StructType\JP_ExternalDocument[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ExternalDocumentDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ExternalDocumentDocumentItem instanceof \StructType\JP_ExternalDocument) {
                $invalidValues[] = is_object($arrayOfJP_ExternalDocumentDocumentItem) ? get_class($arrayOfJP_ExternalDocumentDocumentItem) : sprintf('%s(%s)', gettype($arrayOfJP_ExternalDocumentDocumentItem), var_export($arrayOfJP_ExternalDocumentDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\JP_ExternalDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExternalDocument[] $document
     * @return \ArrayType\ArrayOfJP_ExternalDocument
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExternalDocument $item
     * @return \ArrayType\ArrayOfJP_ExternalDocument
     */
    public function addToDocument(\StructType\JP_ExternalDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ExternalDocument) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\JP_ExternalDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ExternalDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ExternalDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ExternalDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ExternalDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ExternalDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Document
     */
    public function getAttributeName()
    {
        return 'Document';
    }
}
