<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageAdditionalElement StructType
 * @subpackage Structs
 */
class JP_PackageAdditionalElement extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Class
     * @var string
     */
    public $Class;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The SpecialType
     * @var string
     */
    public $SpecialType;
    /**
     * The DirectPayment
     * @var bool
     */
    public $DirectPayment;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Optional
     * @var bool
     */
    public $Optional;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Begin
     * @var string
     */
    public $Begin;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The ApplicationType
     * @var string
     */
    public $ApplicationType;
    /**
     * Constructor method for JP_PackageAdditionalElement
     * @uses JP_PackageAdditionalElement::setName()
     * @uses JP_PackageAdditionalElement::setDescription()
     * @uses JP_PackageAdditionalElement::setPrices()
     * @uses JP_PackageAdditionalElement::setCode()
     * @uses JP_PackageAdditionalElement::setClass()
     * @uses JP_PackageAdditionalElement::setType()
     * @uses JP_PackageAdditionalElement::setCategory()
     * @uses JP_PackageAdditionalElement::setSpecialType()
     * @uses JP_PackageAdditionalElement::setDirectPayment()
     * @uses JP_PackageAdditionalElement::setNonRefundable()
     * @uses JP_PackageAdditionalElement::setOptional()
     * @uses JP_PackageAdditionalElement::setQuantity()
     * @uses JP_PackageAdditionalElement::setBegin()
     * @uses JP_PackageAdditionalElement::setEnd()
     * @uses JP_PackageAdditionalElement::setAmount()
     * @uses JP_PackageAdditionalElement::setCurrency()
     * @uses JP_PackageAdditionalElement::setRatePlanCode()
     * @uses JP_PackageAdditionalElement::setOrder()
     * @uses JP_PackageAdditionalElement::setApplicationType()
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $code
     * @param string $class
     * @param string $type
     * @param string $category
     * @param string $specialType
     * @param bool $directPayment
     * @param bool $nonRefundable
     * @param bool $optional
     * @param int $quantity
     * @param string $begin
     * @param string $end
     * @param float $amount
     * @param string $currency
     * @param string $ratePlanCode
     * @param int $order
     * @param string $applicationType
     */
    public function __construct($name = null, $description = null, \ArrayType\ArrayOfJP_Price $prices = null, $code = null, $class = null, $type = null, $category = null, $specialType = null, $directPayment = null, $nonRefundable = null, $optional = null, $quantity = null, $begin = null, $end = null, $amount = null, $currency = null, $ratePlanCode = null, $order = null, $applicationType = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setPrices($prices)
            ->setCode($code)
            ->setClass($class)
            ->setType($type)
            ->setCategory($category)
            ->setSpecialType($specialType)
            ->setDirectPayment($directPayment)
            ->setNonRefundable($nonRefundable)
            ->setOptional($optional)
            ->setQuantity($quantity)
            ->setBegin($begin)
            ->setEnd($end)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setRatePlanCode($ratePlanCode)
            ->setOrder($order)
            ->setApplicationType($applicationType);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_SupplementType::valueIsValid()
     * @uses \EnumType\JP_SupplementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SupplementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_SupplementType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_SupplementType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get SpecialType value
     * @return string|null
     */
    public function getSpecialType()
    {
        return $this->SpecialType;
    }
    /**
     * Set SpecialType value
     * @param string $specialType
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setSpecialType($specialType = null)
    {
        // validation for constraint: string
        if (!is_null($specialType) && !is_string($specialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialType, true), gettype($specialType)), __LINE__);
        }
        $this->SpecialType = $specialType;
        return $this;
    }
    /**
     * Get DirectPayment value
     * @return bool|null
     */
    public function getDirectPayment()
    {
        return $this->DirectPayment;
    }
    /**
     * Set DirectPayment value
     * @param bool $directPayment
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setDirectPayment($directPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($directPayment) && !is_bool($directPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directPayment, true), gettype($directPayment)), __LINE__);
        }
        $this->DirectPayment = $directPayment;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundable, true), gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Optional value
     * @return bool|null
     */
    public function getOptional()
    {
        return $this->Optional;
    }
    /**
     * Set Optional value
     * @param bool $optional
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setOptional($optional = null)
    {
        // validation for constraint: boolean
        if (!is_null($optional) && !is_bool($optional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optional, true), gettype($optional)), __LINE__);
        }
        $this->Optional = $optional;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Begin value
     * @return string|null
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setBegin($begin = null)
    {
        // validation for constraint: string
        if (!is_null($begin) && !is_string($begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($begin, true), gettype($begin)), __LINE__);
        }
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @uses \EnumType\JP_SupplementApplicationType::valueIsValid()
     * @uses \EnumType\JP_SupplementApplicationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationType
     * @return \StructType\JP_PackageAdditionalElement
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SupplementApplicationType::valueIsValid($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_SupplementApplicationType', is_array($applicationType) ? implode(', ', $applicationType) : var_export($applicationType, true), implode(', ', \EnumType\JP_SupplementApplicationType::getValidValues())), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
}
