<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transport ServiceType
 * @subpackage Services
 */
class Transport extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransportBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for Transports.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportBooking $parameters
     * @return \StructType\TransportBookingResponse|bool
     */
    public function TransportBooking(\StructType\TransportBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportTicketing
     * Meta information extracted from the WSDL
     * - documentation: Ticketing for Transports.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportTicketing $parameters
     * @return \StructType\TransportTicketingResponse|bool
     */
    public function TransportTicketing(\StructType\TransportTicketing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportTicketing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for Transports.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportAvail $parameters
     * @return \StructType\TransportAvailResponse|bool
     */
    public function TransportAvail(\StructType\TransportAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportRoutePortfolio
     * Meta information extracted from the WSDL
     * - documentation: Paged Portfolio of TransportRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportRoutePortfolio $parameters
     * @return \StructType\TransportRoutePortfolioResponse|bool
     */
    public function TransportRoutePortfolio(\StructType\TransportRoutePortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportRoutePortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportCatalogueData
     * Meta information extracted from the WSDL
     * - documentation: Catalogue For Transports
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportCatalogueData $parameters
     * @return \StructType\TransportCatalogueDataResponse|bool
     */
    public function TransportCatalogueData(\StructType\TransportCatalogueData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportCatalogueData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for Transports.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportCheckAvail $parameters
     * @return \StructType\TransportCheckAvailResponse|bool
     */
    public function TransportCheckAvail(\StructType\TransportCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransportBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of Transports
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransportBookingRules $parameters
     * @return \StructType\TransportBookingRulesResponse|bool
     */
    public function TransportBookingRules(\StructType\TransportBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransportBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransportAvailResponse|\StructType\TransportBookingResponse|\StructType\TransportBookingRulesResponse|\StructType\TransportCatalogueDataResponse|\StructType\TransportCheckAvailResponse|\StructType\TransportRoutePortfolioResponse|\StructType\TransportTicketingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
