<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransport StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransport extends AbstractStructBase
{
    /**
     * The CountryOfResidence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfResidence;
    /**
     * The Routes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RouteDispo
     */
    public $Routes;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransportDiscount
     */
    public $Discount;
    /**
     * The Airlines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Airline
     */
    public $Airlines;
    /**
     * The PackageContracts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageContracts;
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * The Class
     * @var string
     */
    public $Class;
    /**
     * The LowCost
     * @var bool
     */
    public $LowCost;
    /**
     * The Stops
     * @var int
     */
    public $Stops;
    /**
     * Constructor method for JP_SearchSegmentTransport
     * @uses JP_SearchSegmentTransport::setCountryOfResidence()
     * @uses JP_SearchSegmentTransport::setRoutes()
     * @uses JP_SearchSegmentTransport::setDiscount()
     * @uses JP_SearchSegmentTransport::setAirlines()
     * @uses JP_SearchSegmentTransport::setPackageContracts()
     * @uses JP_SearchSegmentTransport::setCabin()
     * @uses JP_SearchSegmentTransport::setClass()
     * @uses JP_SearchSegmentTransport::setLowCost()
     * @uses JP_SearchSegmentTransport::setStops()
     * @param string $countryOfResidence
     * @param \ArrayType\ArrayOfJP_RouteDispo $routes
     * @param \StructType\JP_TransportDiscount $discount
     * @param \ArrayType\ArrayOfJP_Airline $airlines
     * @param string $packageContracts
     * @param string $cabin
     * @param string $class
     * @param bool $lowCost
     * @param int $stops
     */
    public function __construct($countryOfResidence = null, \ArrayType\ArrayOfJP_RouteDispo $routes = null, \StructType\JP_TransportDiscount $discount = null, \ArrayType\ArrayOfJP_Airline $airlines = null, $packageContracts = null, $cabin = null, $class = null, $lowCost = null, $stops = null)
    {
        $this
            ->setCountryOfResidence($countryOfResidence)
            ->setRoutes($routes)
            ->setDiscount($discount)
            ->setAirlines($airlines)
            ->setPackageContracts($packageContracts)
            ->setCabin($cabin)
            ->setClass($class)
            ->setLowCost($lowCost)
            ->setStops($stops);
    }
    /**
     * Get CountryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param string $countryOfResidence
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfResidence, true), gettype($countryOfResidence)), __LINE__);
        }
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get Routes value
     * @return \ArrayType\ArrayOfJP_RouteDispo|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \ArrayType\ArrayOfJP_RouteDispo $routes
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setRoutes(\ArrayType\ArrayOfJP_RouteDispo $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\JP_TransportDiscount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\JP_TransportDiscount $discount
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setDiscount(\StructType\JP_TransportDiscount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Airlines value
     * @return \ArrayType\ArrayOfJP_Airline|null
     */
    public function getAirlines()
    {
        return $this->Airlines;
    }
    /**
     * Set Airlines value
     * @param \ArrayType\ArrayOfJP_Airline $airlines
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setAirlines(\ArrayType\ArrayOfJP_Airline $airlines = null)
    {
        $this->Airlines = $airlines;
        return $this;
    }
    /**
     * Get PackageContracts value
     * @return string|null
     */
    public function getPackageContracts()
    {
        return $this->PackageContracts;
    }
    /**
     * Set PackageContracts value
     * @uses \EnumType\JP_PackageContracts::valueIsValid()
     * @uses \EnumType\JP_PackageContracts::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageContracts
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setPackageContracts($packageContracts = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_PackageContracts::valueIsValid($packageContracts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_PackageContracts', is_array($packageContracts) ? implode(', ', $packageContracts) : var_export($packageContracts, true), implode(', ', \EnumType\JP_PackageContracts::getValidValues())), __LINE__);
        }
        $this->PackageContracts = $packageContracts;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \EnumType\JP_CabinType::valueIsValid()
     * @uses \EnumType\JP_CabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_CabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_CabinType', is_array($cabin) ? implode(', ', $cabin) : var_export($cabin, true), implode(', ', \EnumType\JP_CabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool|null
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowCost, true), gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \StructType\JP_SearchSegmentTransport
     */
    public function setStops($stops = null)
    {
        // validation for constraint: int
        if (!is_null($stops) && !(is_int($stops) || ctype_digit($stops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops, true), gettype($stops)), __LINE__);
        }
        $this->Stops = $stops;
        return $this;
    }
}
