<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Promotion StructType
 * @subpackage Structs
 */
class JP_Promotion extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for JP_Promotion
     * @uses JP_Promotion::setName()
     * @uses JP_Promotion::setDescription()
     * @uses JP_Promotion::setComments()
     * @uses JP_Promotion::setType()
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param string $type
     */
    public function __construct($name = null, $description = null, \ArrayType\ArrayOfJP_Comment $comments = null, $type = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setComments($comments)
            ->setType($type);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Promotion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_Promotion
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_Promotion
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_DiscountType::valueIsValid()
     * @uses \EnumType\JP_DiscountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_Promotion
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_DiscountType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_DiscountType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_DiscountType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
