<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ContractCharacteristics ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ContractCharacteristics extends AbstractStructArrayBase
{
    /**
     * The Characteristic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Characteristic;
    /**
     * Constructor method for ArrayOfJP_ContractCharacteristics
     * @uses ArrayOfJP_ContractCharacteristics::setCharacteristic()
     * @param string[] $characteristic
     */
    public function __construct(array $characteristic = array())
    {
        $this
            ->setCharacteristic($characteristic);
    }
    /**
     * Get Characteristic value
     * @return string[]|null
     */
    public function getCharacteristic()
    {
        return $this->Characteristic;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicForArrayConstraintsFromSetCharacteristic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ContractCharacteristicsCharacteristicItem) {
            // validation for constraint: enumeration
            if (!\EnumType\JP_ContractCharacteristics::valueIsValid($arrayOfJP_ContractCharacteristicsCharacteristicItem)) {
                $invalidValues[] = is_object($arrayOfJP_ContractCharacteristicsCharacteristicItem) ? get_class($arrayOfJP_ContractCharacteristicsCharacteristicItem) : sprintf('%s(%s)', gettype($arrayOfJP_ContractCharacteristicsCharacteristicItem), var_export($arrayOfJP_ContractCharacteristicsCharacteristicItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ContractCharacteristics', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\JP_ContractCharacteristics::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Characteristic value
     * @uses \EnumType\JP_ContractCharacteristics::valueIsValid()
     * @uses \EnumType\JP_ContractCharacteristics::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $characteristic
     * @return \ArrayType\ArrayOfJP_ContractCharacteristics
     */
    public function setCharacteristic(array $characteristic = array())
    {
        // validation for constraint: array
        if ('' !== ($characteristicArrayErrorMessage = self::validateCharacteristicForArrayConstraintsFromSetCharacteristic($characteristic))) {
            throw new \InvalidArgumentException($characteristicArrayErrorMessage, __LINE__);
        }
        $this->Characteristic = $characteristic;
        return $this;
    }
    /**
     * Add item to Characteristic value
     * @uses \EnumType\JP_ContractCharacteristics::valueIsValid()
     * @uses \EnumType\JP_ContractCharacteristics::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfJP_ContractCharacteristics
     */
    public function addToCharacteristic($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ContractCharacteristics::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ContractCharacteristics', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\JP_ContractCharacteristics::getValidValues())), __LINE__);
        }
        $this->Characteristic[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\JP_ContractCharacteristics::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfJP_ContractCharacteristics
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ContractCharacteristics::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ContractCharacteristics', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\JP_ContractCharacteristics::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Characteristic
     */
    public function getAttributeName()
    {
        return 'Characteristic';
    }
}
