<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Transport StructType
 * @subpackage Structs
 */
class JP_Transport extends AbstractStructBase
{
    /**
     * The Routes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransportRoutes
     */
    public $Routes;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AdditionalElements
     */
    public $AdditionalElements;
    /**
     * The Rules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransportRule
     */
    public $Rules;
    /**
     * The InfoExtra
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_InfoExtra[]
     */
    public $InfoExtra;
    /**
     * The OptionalFares
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalFares
     */
    public $OptionalFares;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalElements
     */
    public $OptionalElements;
    /**
     * The FareType
     * @var string
     */
    public $FareType;
    /**
     * The AvailableSeats
     * @var int
     */
    public $AvailableSeats;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The LowCost
     * @var bool
     */
    public $LowCost;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The BrandedCode
     * @var string
     */
    public $BrandedCode;
    /**
     * Constructor method for JP_Transport
     * @uses JP_Transport::setRoutes()
     * @uses JP_Transport::setPrices()
     * @uses JP_Transport::setAdditionalElements()
     * @uses JP_Transport::setRules()
     * @uses JP_Transport::setInfoExtra()
     * @uses JP_Transport::setOptionalFares()
     * @uses JP_Transport::setOptionalElements()
     * @uses JP_Transport::setFareType()
     * @uses JP_Transport::setAvailableSeats()
     * @uses JP_Transport::setNumber()
     * @uses JP_Transport::setDirection()
     * @uses JP_Transport::setLowCost()
     * @uses JP_Transport::setRatePlanCode()
     * @uses JP_Transport::setStatus()
     * @uses JP_Transport::setICode()
     * @uses JP_Transport::setSearchMore()
     * @uses JP_Transport::setOrder()
     * @uses JP_Transport::setSource()
     * @uses JP_Transport::setBrandedCode()
     * @param \StructType\JP_TransportRoutes $routes
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_TransportRule $rules
     * @param \StructType\JP_InfoExtra[] $infoExtra
     * @param \StructType\JP_OptionalFares $optionalFares
     * @param \StructType\JP_OptionalElements $optionalElements
     * @param string $fareType
     * @param int $availableSeats
     * @param string $number
     * @param string $direction
     * @param bool $lowCost
     * @param string $ratePlanCode
     * @param string $status
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     * @param string $source
     * @param string $brandedCode
     */
    public function __construct(\StructType\JP_TransportRoutes $routes = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_AdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_TransportRule $rules = null, array $infoExtra = array(), \StructType\JP_OptionalFares $optionalFares = null, \StructType\JP_OptionalElements $optionalElements = null, $fareType = null, $availableSeats = null, $number = null, $direction = null, $lowCost = null, $ratePlanCode = null, $status = null, $iCode = null, $searchMore = null, $order = null, $source = null, $brandedCode = null)
    {
        $this
            ->setRoutes($routes)
            ->setPrices($prices)
            ->setAdditionalElements($additionalElements)
            ->setRules($rules)
            ->setInfoExtra($infoExtra)
            ->setOptionalFares($optionalFares)
            ->setOptionalElements($optionalElements)
            ->setFareType($fareType)
            ->setAvailableSeats($availableSeats)
            ->setNumber($number)
            ->setDirection($direction)
            ->setLowCost($lowCost)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order)
            ->setSource($source)
            ->setBrandedCode($brandedCode);
    }
    /**
     * Get Routes value
     * @return \StructType\JP_TransportRoutes|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \StructType\JP_TransportRoutes $routes
     * @return \StructType\JP_Transport
     */
    public function setRoutes(\StructType\JP_TransportRoutes $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_Transport
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_AdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @return \StructType\JP_Transport
     */
    public function setAdditionalElements(\StructType\JP_AdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get Rules value
     * @return \ArrayType\ArrayOfJP_TransportRule|null
     */
    public function getRules()
    {
        return $this->Rules;
    }
    /**
     * Set Rules value
     * @param \ArrayType\ArrayOfJP_TransportRule $rules
     * @return \StructType\JP_Transport
     */
    public function setRules(\ArrayType\ArrayOfJP_TransportRule $rules = null)
    {
        $this->Rules = $rules;
        return $this;
    }
    /**
     * Get InfoExtra value
     * @return \StructType\JP_InfoExtra[]|null
     */
    public function getInfoExtra()
    {
        return $this->InfoExtra;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoExtra method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoExtra method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoExtraForArrayConstraintsFromSetInfoExtra(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_TransportInfoExtraItem) {
            // validation for constraint: itemType
            if (!$jP_TransportInfoExtraItem instanceof \StructType\JP_InfoExtra) {
                $invalidValues[] = is_object($jP_TransportInfoExtraItem) ? get_class($jP_TransportInfoExtraItem) : sprintf('%s(%s)', gettype($jP_TransportInfoExtraItem), var_export($jP_TransportInfoExtraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InfoExtra property can only contain items of type \StructType\JP_InfoExtra, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InfoExtra value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InfoExtra[] $infoExtra
     * @return \StructType\JP_Transport
     */
    public function setInfoExtra(array $infoExtra = array())
    {
        // validation for constraint: array
        if ('' !== ($infoExtraArrayErrorMessage = self::validateInfoExtraForArrayConstraintsFromSetInfoExtra($infoExtra))) {
            throw new \InvalidArgumentException($infoExtraArrayErrorMessage, __LINE__);
        }
        $this->InfoExtra = $infoExtra;
        return $this;
    }
    /**
     * Add item to InfoExtra value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InfoExtra $item
     * @return \StructType\JP_Transport
     */
    public function addToInfoExtra(\StructType\JP_InfoExtra $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_InfoExtra) {
            throw new \InvalidArgumentException(sprintf('The InfoExtra property can only contain items of type \StructType\JP_InfoExtra, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InfoExtra[] = $item;
        return $this;
    }
    /**
     * Get OptionalFares value
     * @return \StructType\JP_OptionalFares|null
     */
    public function getOptionalFares()
    {
        return $this->OptionalFares;
    }
    /**
     * Set OptionalFares value
     * @param \StructType\JP_OptionalFares $optionalFares
     * @return \StructType\JP_Transport
     */
    public function setOptionalFares(\StructType\JP_OptionalFares $optionalFares = null)
    {
        $this->OptionalFares = $optionalFares;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_OptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_OptionalElements $optionalElements
     * @return \StructType\JP_Transport
     */
    public function setOptionalElements(\StructType\JP_OptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\JP_Transport
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareType, true), gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get AvailableSeats value
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return $this->AvailableSeats;
    }
    /**
     * Set AvailableSeats value
     * @param int $availableSeats
     * @return \StructType\JP_Transport
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !(is_int($availableSeats) || ctype_digit($availableSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeats, true), gettype($availableSeats)), __LINE__);
        }
        $this->AvailableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\JP_Transport
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_Transport
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool|null
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_Transport
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowCost, true), gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_Transport
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_Transport
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_Transport
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_Transport
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchMore, true), gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_Transport
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_Transport
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get BrandedCode value
     * @return string|null
     */
    public function getBrandedCode()
    {
        return $this->BrandedCode;
    }
    /**
     * Set BrandedCode value
     * @param string $brandedCode
     * @return \StructType\JP_Transport
     */
    public function setBrandedCode($brandedCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandedCode) && !is_string($brandedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandedCode, true), gettype($brandedCode)), __LINE__);
        }
        $this->BrandedCode = $brandedCode;
        return $this;
    }
}
