<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Location StructType
 * @subpackage Structs
 */
class JP_Location extends AbstractStructBase
{
    /**
     * The idZonOrigen
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $idZonOrigen;
    /**
     * The idZonDestino
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $idZonDestino;
    /**
     * The OriginPortCode
     * @var string
     */
    public $OriginPortCode;
    /**
     * The DestinationPortCode
     * @var string
     */
    public $DestinationPortCode;
    /**
     * The DescriptionOriginPort
     * @var string
     */
    public $DescriptionOriginPort;
    /**
     * The DescriptionDestinationPort
     * @var string
     */
    public $DescriptionDestinationPort;
    /**
     * The TipoProducto
     * @var string
     */
    public $TipoProducto;
    /**
     * Constructor method for JP_Location
     * @uses JP_Location::setIdZonOrigen()
     * @uses JP_Location::setIdZonDestino()
     * @uses JP_Location::setOriginPortCode()
     * @uses JP_Location::setDestinationPortCode()
     * @uses JP_Location::setDescriptionOriginPort()
     * @uses JP_Location::setDescriptionDestinationPort()
     * @uses JP_Location::setTipoProducto()
     * @param int $idZonOrigen
     * @param int $idZonDestino
     * @param string $originPortCode
     * @param string $destinationPortCode
     * @param string $descriptionOriginPort
     * @param string $descriptionDestinationPort
     * @param string $tipoProducto
     */
    public function __construct($idZonOrigen = null, $idZonDestino = null, $originPortCode = null, $destinationPortCode = null, $descriptionOriginPort = null, $descriptionDestinationPort = null, $tipoProducto = null)
    {
        $this
            ->setIdZonOrigen($idZonOrigen)
            ->setIdZonDestino($idZonDestino)
            ->setOriginPortCode($originPortCode)
            ->setDestinationPortCode($destinationPortCode)
            ->setDescriptionOriginPort($descriptionOriginPort)
            ->setDescriptionDestinationPort($descriptionDestinationPort)
            ->setTipoProducto($tipoProducto);
    }
    /**
     * Get idZonOrigen value
     * @return int
     */
    public function getIdZonOrigen()
    {
        return $this->idZonOrigen;
    }
    /**
     * Set idZonOrigen value
     * @param int $idZonOrigen
     * @return \StructType\JP_Location
     */
    public function setIdZonOrigen($idZonOrigen = null)
    {
        // validation for constraint: int
        if (!is_null($idZonOrigen) && !(is_int($idZonOrigen) || ctype_digit($idZonOrigen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idZonOrigen, true), gettype($idZonOrigen)), __LINE__);
        }
        $this->idZonOrigen = $idZonOrigen;
        return $this;
    }
    /**
     * Get idZonDestino value
     * @return int
     */
    public function getIdZonDestino()
    {
        return $this->idZonDestino;
    }
    /**
     * Set idZonDestino value
     * @param int $idZonDestino
     * @return \StructType\JP_Location
     */
    public function setIdZonDestino($idZonDestino = null)
    {
        // validation for constraint: int
        if (!is_null($idZonDestino) && !(is_int($idZonDestino) || ctype_digit($idZonDestino))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idZonDestino, true), gettype($idZonDestino)), __LINE__);
        }
        $this->idZonDestino = $idZonDestino;
        return $this;
    }
    /**
     * Get OriginPortCode value
     * @return string|null
     */
    public function getOriginPortCode()
    {
        return $this->OriginPortCode;
    }
    /**
     * Set OriginPortCode value
     * @param string $originPortCode
     * @return \StructType\JP_Location
     */
    public function setOriginPortCode($originPortCode = null)
    {
        // validation for constraint: string
        if (!is_null($originPortCode) && !is_string($originPortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originPortCode, true), gettype($originPortCode)), __LINE__);
        }
        $this->OriginPortCode = $originPortCode;
        return $this;
    }
    /**
     * Get DestinationPortCode value
     * @return string|null
     */
    public function getDestinationPortCode()
    {
        return $this->DestinationPortCode;
    }
    /**
     * Set DestinationPortCode value
     * @param string $destinationPortCode
     * @return \StructType\JP_Location
     */
    public function setDestinationPortCode($destinationPortCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPortCode) && !is_string($destinationPortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPortCode, true), gettype($destinationPortCode)), __LINE__);
        }
        $this->DestinationPortCode = $destinationPortCode;
        return $this;
    }
    /**
     * Get DescriptionOriginPort value
     * @return string|null
     */
    public function getDescriptionOriginPort()
    {
        return $this->DescriptionOriginPort;
    }
    /**
     * Set DescriptionOriginPort value
     * @param string $descriptionOriginPort
     * @return \StructType\JP_Location
     */
    public function setDescriptionOriginPort($descriptionOriginPort = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionOriginPort) && !is_string($descriptionOriginPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionOriginPort, true), gettype($descriptionOriginPort)), __LINE__);
        }
        $this->DescriptionOriginPort = $descriptionOriginPort;
        return $this;
    }
    /**
     * Get DescriptionDestinationPort value
     * @return string|null
     */
    public function getDescriptionDestinationPort()
    {
        return $this->DescriptionDestinationPort;
    }
    /**
     * Set DescriptionDestinationPort value
     * @param string $descriptionDestinationPort
     * @return \StructType\JP_Location
     */
    public function setDescriptionDestinationPort($descriptionDestinationPort = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionDestinationPort) && !is_string($descriptionDestinationPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionDestinationPort, true), gettype($descriptionDestinationPort)), __LINE__);
        }
        $this->DescriptionDestinationPort = $descriptionDestinationPort;
        return $this;
    }
    /**
     * Get TipoProducto value
     * @return string|null
     */
    public function getTipoProducto()
    {
        return $this->TipoProducto;
    }
    /**
     * Set TipoProducto value
     * @param string $tipoProducto
     * @return \StructType\JP_Location
     */
    public function setTipoProducto($tipoProducto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoProducto) && !is_string($tipoProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoProducto, true), gettype($tipoProducto)), __LINE__);
        }
        $this->TipoProducto = $tipoProducto;
        return $this;
    }
}
