<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransportTicketInfo StructType
 * @subpackage Structs
 */
class JP_TransportTicketInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Paxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Locator
     * @var string
     */
    public $Locator;
    /**
     * Constructor method for JP_TransportTicketInfo
     * @uses JP_TransportTicketInfo::setStatus()
     * @uses JP_TransportTicketInfo::setPaxes()
     * @uses JP_TransportTicketInfo::setLocator()
     * @param string $status
     * @param \StructType\JP_Paxes $paxes
     * @param string $locator
     */
    public function __construct($status = null, \StructType\JP_Paxes $paxes = null, $locator = null)
    {
        $this
            ->setStatus($status)
            ->setPaxes($paxes)
            ->setLocator($locator);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\JP_TransportTicketInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_TransportTicketInfo
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Locator value
     * @return string|null
     */
    public function getLocator()
    {
        return $this->Locator;
    }
    /**
     * Set Locator value
     * @param string $locator
     * @return \StructType\JP_TransportTicketInfo
     */
    public function setLocator($locator = null)
    {
        // validation for constraint: string
        if (!is_null($locator) && !is_string($locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locator, true), gettype($locator)), __LINE__);
        }
        $this->Locator = $locator;
        return $this;
    }
}
