<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransportLocator StructType
 * @subpackage Structs
 */
class JP_TransportLocator extends AbstractStructBase
{
    /**
     * The ReservationLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationLocator;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TicketCommission
     */
    public $Commission;
    /**
     * Constructor method for JP_TransportLocator
     * @uses JP_TransportLocator::setReservationLocator()
     * @uses JP_TransportLocator::setCommission()
     * @param string $reservationLocator
     * @param \StructType\JP_TicketCommission $commission
     */
    public function __construct($reservationLocator = null, \StructType\JP_TicketCommission $commission = null)
    {
        $this
            ->setReservationLocator($reservationLocator)
            ->setCommission($commission);
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_TransportLocator
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationLocator, true), gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\JP_TicketCommission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \StructType\JP_TicketCommission $commission
     * @return \StructType\JP_TransportLocator
     */
    public function setCommission(\StructType\JP_TicketCommission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
}
