<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransfers StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransfers extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Suppliers
     */
    public $Suppliers;
    /**
     * The Bags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Bag
     */
    public $Bags;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * The IdCliRef
     * @var int
     */
    public $IdCliRef;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * The HourType
     * @var string
     */
    public $HourType;
    /**
     * The OriginLatitude
     * @var float
     */
    public $OriginLatitude;
    /**
     * The OriginLongitude
     * @var float
     */
    public $OriginLongitude;
    /**
     * The DestinationLatitude
     * @var float
     */
    public $DestinationLatitude;
    /**
     * The DestinationLongitude
     * @var float
     */
    public $DestinationLongitude;
    /**
     * Constructor method for JP_SearchSegmentTransfers
     * @uses JP_SearchSegmentTransfers::setSuppliers()
     * @uses JP_SearchSegmentTransfers::setBags()
     * @uses JP_SearchSegmentTransfers::setHour()
     * @uses JP_SearchSegmentTransfers::setHourEnd()
     * @uses JP_SearchSegmentTransfers::setType()
     * @uses JP_SearchSegmentTransfers::setInternalSupplier()
     * @uses JP_SearchSegmentTransfers::setIdCliRef()
     * @uses JP_SearchSegmentTransfers::setRoute()
     * @uses JP_SearchSegmentTransfers::setCode()
     * @uses JP_SearchSegmentTransfers::setOptionCode()
     * @uses JP_SearchSegmentTransfers::setHourType()
     * @uses JP_SearchSegmentTransfers::setOriginLatitude()
     * @uses JP_SearchSegmentTransfers::setOriginLongitude()
     * @uses JP_SearchSegmentTransfers::setDestinationLatitude()
     * @uses JP_SearchSegmentTransfers::setDestinationLongitude()
     * @param \StructType\JP_Suppliers $suppliers
     * @param \ArrayType\ArrayOfJP_Bag $bags
     * @param string $hour
     * @param string $hourEnd
     * @param int $type
     * @param int $internalSupplier
     * @param int $idCliRef
     * @param string $route
     * @param string $code
     * @param string $optionCode
     * @param string $hourType
     * @param float $originLatitude
     * @param float $originLongitude
     * @param float $destinationLatitude
     * @param float $destinationLongitude
     */
    public function __construct(\StructType\JP_Suppliers $suppliers = null, \ArrayType\ArrayOfJP_Bag $bags = null, $hour = null, $hourEnd = null, $type = null, $internalSupplier = null, $idCliRef = null, $route = null, $code = null, $optionCode = null, $hourType = null, $originLatitude = null, $originLongitude = null, $destinationLatitude = null, $destinationLongitude = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setBags($bags)
            ->setHour($hour)
            ->setHourEnd($hourEnd)
            ->setType($type)
            ->setInternalSupplier($internalSupplier)
            ->setIdCliRef($idCliRef)
            ->setRoute($route)
            ->setCode($code)
            ->setOptionCode($optionCode)
            ->setHourType($hourType)
            ->setOriginLatitude($originLatitude)
            ->setOriginLongitude($originLongitude)
            ->setDestinationLatitude($destinationLatitude)
            ->setDestinationLongitude($destinationLongitude);
    }
    /**
     * Get Suppliers value
     * @return \StructType\JP_Suppliers|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \StructType\JP_Suppliers $suppliers
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setSuppliers(\StructType\JP_Suppliers $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get Bags value
     * @return \ArrayType\ArrayOfJP_Bag|null
     */
    public function getBags()
    {
        return $this->Bags;
    }
    /**
     * Set Bags value
     * @param \ArrayType\ArrayOfJP_Bag $bags
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setBags(\ArrayType\ArrayOfJP_Bag $bags = null)
    {
        $this->Bags = $bags;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourEnd, true), gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !(is_int($internalSupplier) || ctype_digit($internalSupplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalSupplier, true), gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
    /**
     * Get IdCliRef value
     * @return int|null
     */
    public function getIdCliRef()
    {
        return $this->IdCliRef;
    }
    /**
     * Set IdCliRef value
     * @param int $idCliRef
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setIdCliRef($idCliRef = null)
    {
        // validation for constraint: int
        if (!is_null($idCliRef) && !(is_int($idCliRef) || ctype_digit($idCliRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliRef, true), gettype($idCliRef)), __LINE__);
        }
        $this->IdCliRef = $idCliRef;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RouteType', is_array($route) ? implode(', ', $route) : var_export($route, true), implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Get HourType value
     * @return string|null
     */
    public function getHourType()
    {
        return $this->HourType;
    }
    /**
     * Set HourType value
     * @uses \EnumType\JP_HourType::valueIsValid()
     * @uses \EnumType\JP_HourType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hourType
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setHourType($hourType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_HourType::valueIsValid($hourType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_HourType', is_array($hourType) ? implode(', ', $hourType) : var_export($hourType, true), implode(', ', \EnumType\JP_HourType::getValidValues())), __LINE__);
        }
        $this->HourType = $hourType;
        return $this;
    }
    /**
     * Get OriginLatitude value
     * @return float|null
     */
    public function getOriginLatitude()
    {
        return $this->OriginLatitude;
    }
    /**
     * Set OriginLatitude value
     * @param float $originLatitude
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setOriginLatitude($originLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($originLatitude) && !(is_float($originLatitude) || is_numeric($originLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originLatitude, true), gettype($originLatitude)), __LINE__);
        }
        $this->OriginLatitude = $originLatitude;
        return $this;
    }
    /**
     * Get OriginLongitude value
     * @return float|null
     */
    public function getOriginLongitude()
    {
        return $this->OriginLongitude;
    }
    /**
     * Set OriginLongitude value
     * @param float $originLongitude
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setOriginLongitude($originLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($originLongitude) && !(is_float($originLongitude) || is_numeric($originLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originLongitude, true), gettype($originLongitude)), __LINE__);
        }
        $this->OriginLongitude = $originLongitude;
        return $this;
    }
    /**
     * Get DestinationLatitude value
     * @return float|null
     */
    public function getDestinationLatitude()
    {
        return $this->DestinationLatitude;
    }
    /**
     * Set DestinationLatitude value
     * @param float $destinationLatitude
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setDestinationLatitude($destinationLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($destinationLatitude) && !(is_float($destinationLatitude) || is_numeric($destinationLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($destinationLatitude, true), gettype($destinationLatitude)), __LINE__);
        }
        $this->DestinationLatitude = $destinationLatitude;
        return $this;
    }
    /**
     * Get DestinationLongitude value
     * @return float|null
     */
    public function getDestinationLongitude()
    {
        return $this->DestinationLongitude;
    }
    /**
     * Set DestinationLongitude value
     * @param float $destinationLongitude
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setDestinationLongitude($destinationLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($destinationLongitude) && !(is_float($destinationLongitude) || is_numeric($destinationLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($destinationLongitude, true), gettype($destinationLongitude)), __LINE__);
        }
        $this->DestinationLongitude = $destinationLongitude;
        return $this;
    }
}
