<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransportSegment ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransportSegment extends AbstractStructArrayBase
{
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransportSegment[]
     */
    public $Segment;
    /**
     * Constructor method for ArrayOfJP_TransportSegment
     * @uses ArrayOfJP_TransportSegment::setSegment()
     * @param \StructType\JP_TransportSegment[] $segment
     */
    public function __construct(array $segment = array())
    {
        $this
            ->setSegment($segment);
    }
    /**
     * Get Segment value
     * @return \StructType\JP_TransportSegment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * This method is responsible for validating the values passed to the setSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentForArrayConstraintsFromSetSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_TransportSegmentSegmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransportSegmentSegmentItem instanceof \StructType\JP_TransportSegment) {
                $invalidValues[] = is_object($arrayOfJP_TransportSegmentSegmentItem) ? get_class($arrayOfJP_TransportSegmentSegmentItem) : sprintf('%s(%s)', gettype($arrayOfJP_TransportSegmentSegmentItem), var_export($arrayOfJP_TransportSegmentSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Segment property can only contain items of type \StructType\JP_TransportSegment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransportSegment[] $segment
     * @return \ArrayType\ArrayOfJP_TransportSegment
     */
    public function setSegment(array $segment = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentArrayErrorMessage = self::validateSegmentForArrayConstraintsFromSetSegment($segment))) {
            throw new \InvalidArgumentException($segmentArrayErrorMessage, __LINE__);
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransportSegment $item
     * @return \ArrayType\ArrayOfJP_TransportSegment
     */
    public function addToSegment(\StructType\JP_TransportSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransportSegment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of type \StructType\JP_TransportSegment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransportSegment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransportSegment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransportSegment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransportSegment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransportSegment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Segment
     */
    public function getAttributeName()
    {
        return 'Segment';
    }
}
