<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrayOfJP_TransportTicketInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfArrayOfJP_TransportTicketInfo extends AbstractStructArrayBase
{
    /**
     * The Reservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransportTicketInfo[]
     */
    public $Reservation;
    /**
     * Constructor method for ArrayOfArrayOfJP_TransportTicketInfo
     * @uses ArrayOfArrayOfJP_TransportTicketInfo::setReservation()
     * @param \ArrayType\ArrayOfJP_TransportTicketInfo[] $reservation
     */
    public function __construct(array $reservation = array())
    {
        $this
            ->setReservation($reservation);
    }
    /**
     * Get Reservation value
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo[]|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * This method is responsible for validating the values passed to the setReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationForArrayConstraintsFromSetReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfArrayOfJP_TransportTicketInfoReservationItem) {
            // validation for constraint: itemType
            if (!$arrayOfArrayOfJP_TransportTicketInfoReservationItem instanceof \ArrayType\ArrayOfJP_TransportTicketInfo) {
                $invalidValues[] = is_object($arrayOfArrayOfJP_TransportTicketInfoReservationItem) ? get_class($arrayOfArrayOfJP_TransportTicketInfoReservationItem) : sprintf('%s(%s)', gettype($arrayOfArrayOfJP_TransportTicketInfoReservationItem), var_export($arrayOfArrayOfJP_TransportTicketInfoReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reservation property can only contain items of type \ArrayType\ArrayOfJP_TransportTicketInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reservation value
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfJP_TransportTicketInfo[] $reservation
     * @return \ArrayType\ArrayOfArrayOfJP_TransportTicketInfo
     */
    public function setReservation(array $reservation = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationArrayErrorMessage = self::validateReservationForArrayConstraintsFromSetReservation($reservation))) {
            throw new \InvalidArgumentException($reservationArrayErrorMessage, __LINE__);
        }
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Add item to Reservation value
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfJP_TransportTicketInfo $item
     * @return \ArrayType\ArrayOfArrayOfJP_TransportTicketInfo
     */
    public function addToReservation(\ArrayType\ArrayOfJP_TransportTicketInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ArrayType\ArrayOfJP_TransportTicketInfo) {
            throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of type \ArrayType\ArrayOfJP_TransportTicketInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reservation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ArrayType\ArrayOfJP_TransportTicketInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Reservation
     */
    public function getAttributeName()
    {
        return 'Reservation';
    }
}
