<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseItem StructType
 * @subpackage Structs
 */
class JP_CruiseItem extends JP_BaseItem
{
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseResult
     */
    public $Cruise;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AdditionalElements
     */
    public $AdditionalElements;
    /**
     * The RelPaxesDist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ExtendedRelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for JP_CruiseItem
     * @uses JP_CruiseItem::setCruise()
     * @uses JP_CruiseItem::setAdditionalElements()
     * @uses JP_CruiseItem::setRelPaxesDist()
     * @uses JP_CruiseItem::setStart()
     * @uses JP_CruiseItem::setEnd()
     * @param \StructType\JP_CruiseResult $cruise
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_ExtendedRelPaxDist $relPaxesDist
     * @param string $start
     * @param string $end
     */
    public function __construct(\StructType\JP_CruiseResult $cruise = null, \StructType\JP_AdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_ExtendedRelPaxDist $relPaxesDist = null, $start = null, $end = null)
    {
        $this
            ->setCruise($cruise)
            ->setAdditionalElements($additionalElements)
            ->setRelPaxesDist($relPaxesDist)
            ->setStart($start)
            ->setEnd($end);
    }
    /**
     * Get Cruise value
     * @return \StructType\JP_CruiseResult|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \StructType\JP_CruiseResult $cruise
     * @return \StructType\JP_CruiseItem
     */
    public function setCruise(\StructType\JP_CruiseResult $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_AdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @return \StructType\JP_CruiseItem
     */
    public function setAdditionalElements(\StructType\JP_AdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_ExtendedRelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_ExtendedRelPaxDist $relPaxesDist
     * @return \StructType\JP_CruiseItem
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_ExtendedRelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_CruiseItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_CruiseItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
