<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaCheckAvailResult StructType
 * @subpackage Structs
 */
class JP_VisaCheckAvailResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The DestinationZone
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The VisaInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VisaInfo
     */
    public $VisaInfo;
    /**
     * The VisaOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_VisaOption
     */
    public $VisaOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_VisaCheckAvailResult
     * @uses JP_VisaCheckAvailResult::setStart()
     * @uses JP_VisaCheckAvailResult::setEnd()
     * @uses JP_VisaCheckAvailResult::setDestinationZone()
     * @uses JP_VisaCheckAvailResult::setStatus()
     * @uses JP_VisaCheckAvailResult::setVisaInfo()
     * @uses JP_VisaCheckAvailResult::setVisaOptions()
     * @uses JP_VisaCheckAvailResult::setCode()
     * @param string $start
     * @param string $end
     * @param int $destinationZone
     * @param string $status
     * @param \StructType\JP_VisaInfo $visaInfo
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @param string $code
     */
    public function __construct($start = null, $end = null, $destinationZone = null, $status = null, \StructType\JP_VisaInfo $visaInfo = null, \ArrayType\ArrayOfJP_VisaOption $visaOptions = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setDestinationZone($destinationZone)
            ->setStatus($status)
            ->setVisaInfo($visaInfo)
            ->setVisaOptions($visaOptions)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !is_numeric($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get VisaInfo value
     * @return \StructType\JP_VisaInfo|null
     */
    public function getVisaInfo()
    {
        return $this->VisaInfo;
    }
    /**
     * Set VisaInfo value
     * @param \StructType\JP_VisaInfo $visaInfo
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setVisaInfo(\StructType\JP_VisaInfo $visaInfo = null)
    {
        $this->VisaInfo = $visaInfo;
        return $this;
    }
    /**
     * Get VisaOptions value
     * @return \ArrayType\ArrayOfJP_VisaOption|null
     */
    public function getVisaOptions()
    {
        return $this->VisaOptions;
    }
    /**
     * Set VisaOptions value
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setVisaOptions(\ArrayType\ArrayOfJP_VisaOption $visaOptions = null)
    {
        $this->VisaOptions = $visaOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_VisaCheckAvailResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
